/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.gdx.order;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Lists;
import com.tydic.train.constants.TrainOrderStatusEnum;
import com.tydic.train.model.gdx.goods.TrainGdxGoodsDo;
import com.tydic.train.model.gdx.goods.TrainGdxGoodsModel;
import com.tydic.train.model.gdx.order.TrainGdxOrderModel;
import com.tydic.train.model.gdx.order.qrybo.TrainGdxOrderQryBo;
import com.tydic.train.model.gdx.user.TrainGdxUserDo;
import com.tydic.train.model.gdx.user.TrainGdxUserModel;
import com.tydic.train.service.course.exception.BaseBusinessException;
import com.tydic.train.service.gdx.order.TrainGdxOrderService;
import com.tydic.train.service.gdx.order.bo.TrainGdxCreateOrderReqBo;
import com.tydic.train.service.gdx.order.bo.TrainGdxCreateOrderRspBo;
import com.tydic.train.service.gdx.order.bo.TrainGdxOrderBo;
import com.tydic.train.service.gdx.order.bo.TrainGdxOrderItemBo;
import com.tydic.train.service.gdx.order.bo.TrainGdxQueryOrderReqBo;
import com.tydic.train.service.gdx.order.bo.TrainGdxQueryOrderRspBo;
import com.tydic.train.service.gdx.order.bo.TrainGdxUpdateOrderReqBo;
import com.tydic.train.service.gdx.order.bo.TrainGdxUpdateRspBo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.gdx.order.TrainGdxOrderService"})
public class TrainGdxOrderServiceImpl
implements TrainGdxOrderService {
    private final TrainGdxOrderModel trainGdxOrderModel;
    private final TrainGdxUserModel trainGdxUserModel;
    private final TrainGdxGoodsModel trainGdxGoodsModel;

    @PostMapping(value={"createOrder"})
    public TrainGdxCreateOrderRspBo createOrder(@RequestBody TrainGdxCreateOrderReqBo reqBo) {
        if (reqBo == null || reqBo.getGoodsId() == null || reqBo.getUserId() == null || reqBo.getNum() == null) {
            throw new BaseBusinessException("1001", "\u53c2\u6570\u9519\u8bef");
        }
        TrainGdxUserDo byId = this.trainGdxUserModel.getById(reqBo.getUserId());
        if (byId == null) {
            throw new BaseBusinessException("1002", "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        TrainGdxGoodsDo trainGdxGoodsDo = this.trainGdxGoodsModel.getById(reqBo.getGoodsId());
        if (trainGdxGoodsDo == null) {
            throw new BaseBusinessException("1003", "\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        TrainGdxOrderBo trainGdxOrderBo = new TrainGdxOrderBo();
        trainGdxOrderBo.setOrderNo(DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        trainGdxOrderBo.setOrderName(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + "\u7684\u8ba2\u5355");
        trainGdxOrderBo.setOrderMoney(trainGdxGoodsDo.getGoodsPrice().multiply(new BigDecimal(reqBo.getNum())));
        trainGdxOrderBo.setCreateUserId(reqBo.getUserId());
        trainGdxOrderBo.setCreateUserName(byId.getUserName());
        trainGdxOrderBo.setCreateTime(new Date());
        trainGdxOrderBo.setOrderStatus(TrainOrderStatusEnum.O_000.getOrderStatus());
        TrainGdxOrderItemBo trainGdxOrderItemBo = new TrainGdxOrderItemBo();
        trainGdxOrderItemBo.setGoodsId(reqBo.getGoodsId());
        trainGdxOrderItemBo.setGoodsPrice(trainGdxGoodsDo.getGoodsPrice());
        trainGdxOrderItemBo.setCount(reqBo.getNum());
        trainGdxOrderItemBo.setTotalMoney(trainGdxGoodsDo.getGoodsPrice().multiply(new BigDecimal(reqBo.getNum())));
        trainGdxOrderBo.setOrderItemList((List)Lists.newArrayList((Object[])new TrainGdxOrderItemBo[]{trainGdxOrderItemBo}));
        Long orderId = this.trainGdxOrderModel.createOrder(trainGdxOrderBo);
        return new TrainGdxCreateOrderRspBo(orderId);
    }

    @PostMapping(value={"queryOrder"})
    public TrainGdxQueryOrderRspBo queryOrder(@RequestBody TrainGdxQueryOrderReqBo reqBo) {
        if (reqBo == null || reqBo.getOrderId() == null) {
            throw new BaseBusinessException("1005", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TrainGdxOrderQryBo orderQryBo = new TrainGdxOrderQryBo();
        orderQryBo.setOrderId(reqBo.getOrderId());
        TrainGdxOrderBo trainGdxOrderBo = this.trainGdxOrderModel.queryOrder(orderQryBo);
        return (TrainGdxQueryOrderRspBo)BeanUtil.copyProperties((Object)trainGdxOrderBo, TrainGdxQueryOrderRspBo.class);
    }

    @PostMapping(value={"updateOrder"})
    public TrainGdxUpdateRspBo updateOrder(@RequestBody TrainGdxUpdateOrderReqBo reqBo) {
        this.trainGdxOrderModel.updateOrder(reqBo.getTrainGdxOrderBo());
        return new TrainGdxUpdateRspBo();
    }

    public TrainGdxOrderServiceImpl(TrainGdxOrderModel trainGdxOrderModel, TrainGdxUserModel trainGdxUserModel, TrainGdxGoodsModel trainGdxGoodsModel) {
        this.trainGdxOrderModel = trainGdxOrderModel;
        this.trainGdxUserModel = trainGdxUserModel;
        this.trainGdxGoodsModel = trainGdxGoodsModel;
    }
}

