/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.lsq.order;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.lsq.goods.ITrainLsqGoodsModel;
import com.tydic.train.model.lsq.goods.TrainLsqGoodsDO;
import com.tydic.train.model.lsq.order.ITrainLsqOrderModel;
import com.tydic.train.model.lsq.order.TrainLsqOrderDO;
import com.tydic.train.model.lsq.order.sub.TrainLsqOrderItemDO;
import com.tydic.train.model.lsq.user.ITrainLsqUserModel;
import com.tydic.train.model.lsq.user.TrainLsqUserDO;
import com.tydic.train.service.lsq.order.TrainLsqCreateOrderService;
import com.tydic.train.service.lsq.order.bo.TrainLsqCreateOrderReqBO;
import com.tydic.train.service.lsq.order.bo.TrainLsqCreateOrderRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.lsq.order.TrainLsqCreateOrderService"})
public class TrainLsqCreateOrderServiceImpl
implements TrainLsqCreateOrderService {
    @Autowired
    private ITrainLsqUserModel iTrainLsqUserModel;
    @Autowired
    private ITrainLsqGoodsModel iTrainLsqGoodsModel;
    @Autowired
    private ITrainLsqOrderModel iTrainLsqOrderModel;
    private static final Integer not_del = 0;

    @PostMapping(value={"createOrder"})
    public TrainLsqCreateOrderRspBO createOrder(@RequestBody TrainLsqCreateOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        TrainLsqCreateOrderRspBO rspBO = new TrainLsqCreateOrderRspBO();
        TrainLsqUserDO userDO = new TrainLsqUserDO();
        userDO.setUserId(reqBO.getUserId());
        TrainLsqUserDO userDetail = this.iTrainLsqUserModel.qryUserDetail(userDO);
        if (ObjectUtil.isEmpty((Object)userDetail)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7528\u6237\u4e0d\u5b58\u5728");
            return rspBO;
        }
        TrainLsqGoodsDO goodsDO = new TrainLsqGoodsDO();
        goodsDO.setGoodsId(reqBO.getGoodsId());
        TrainLsqGoodsDO goodsDetail = this.iTrainLsqGoodsModel.qryGoodsDetail(goodsDO);
        if (ObjectUtil.isEmpty((Object)goodsDetail)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u4e0d\u5b58\u5728");
            return rspBO;
        }
        TrainLsqOrderDO insertOrderDO = new TrainLsqOrderDO();
        insertOrderDO.setOrderNo(TrainLsqCreateOrderServiceImpl.createOrderNo());
        insertOrderDO.setOrderName(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + userDetail.getUserName() + "\u7684\u8ba2\u5355");
        insertOrderDO.setOrderMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(reqBO.getCount())));
        insertOrderDO.setCreateUserId(userDetail.getUserId());
        insertOrderDO.setCreateUserName(userDetail.getUserName());
        insertOrderDO.setCreateTime(new Date());
        insertOrderDO.setDelFlag(not_del);
        insertOrderDO.setOrderStatus(1);
        Long orderId = this.iTrainLsqOrderModel.insertOrder(insertOrderDO);
        TrainLsqOrderItemDO insertOrderItemDO = new TrainLsqOrderItemDO();
        insertOrderItemDO.setOrderId(orderId);
        insertOrderItemDO.setGoodsId(goodsDetail.getGoodsId());
        insertOrderItemDO.setGoodsPrice(goodsDetail.getGoodsPrice());
        insertOrderItemDO.setCount(reqBO.getCount());
        insertOrderItemDO.setTotalMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(reqBO.getCount())));
        insertOrderItemDO.setDelFlag(not_del);
        this.iTrainLsqOrderModel.insertOrderItem(insertOrderItemDO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setOrderId(orderId);
        return rspBO;
    }

    public static String createOrderNo() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = sdf.format(now);
        Random random = new Random();
        int randomNumber = random.nextInt(9000) + 1000;
        String code = "LSQ_DD" + timestamp + randomNumber;
        return code;
    }

    private void verifyParam(TrainLsqCreateOrderReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUserId())) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getGoodsId())) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u5546\u54c1ID\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCount())) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u8d2d\u4e70\u6570\u91cf\u4e3a\u7a7a");
        }
    }
}

