/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.goods.TrainCyjGoodsDo;
import com.tydic.train.model.goods.TrainCyjGoodsModel;
import com.tydic.train.model.goods.qrybo.TrainCyjGoodsQryBo;
import com.tydic.train.model.order.TrainCyjOrderDo;
import com.tydic.train.model.order.TrainCyjOrderModel;
import com.tydic.train.model.order.qrybo.TrainCyjOrderQryBo;
import com.tydic.train.model.order.sub.TrainCyjOrderItem;
import com.tydic.train.model.user.TrainCyjUserDo;
import com.tydic.train.model.user.TrainCyjUserModel;
import com.tydic.train.model.user.qrybo.TrainCyjUserQryBo;
import com.tydic.train.service.order.TrainCyjOrderService;
import com.tydic.train.service.order.bo.TrainCyjCreateOrderReqBo;
import com.tydic.train.service.order.bo.TrainCyjCreateOrderRsqBo;
import com.tydic.train.service.order.bo.TrainCyjGoodsBo;
import com.tydic.train.service.order.bo.TrainCyjOrderItemBo;
import com.tydic.train.service.order.bo.TrainCyjQryOrderDetailReqBo;
import com.tydic.train.service.order.bo.TrainCyjQryOrderDetailRsqBo;
import com.tydic.train.service.order.bo.TrainCyjUserBo;
import com.tydic.train.utils.JsonUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.order.TrainCyjOrderService"})
public class TrainCyjOrderServiceImpl
implements TrainCyjOrderService {
    @Autowired
    private TrainCyjOrderModel trainCyjOrderModel;
    @Autowired
    private TrainCyjGoodsModel trainCyjGoodsModel;
    @Autowired
    private TrainCyjUserModel trainCyjUserModel;

    @PostMapping(value={"createOrder"})
    public TrainCyjCreateOrderRsqBo createOrder(@RequestBody TrainCyjCreateOrderReqBo reqBO) {
        TrainCyjCreateOrderRsqBo rsqBo = new TrainCyjCreateOrderRsqBo();
        this.validParam(reqBO);
        TrainCyjGoodsQryBo trainCyjGoodsQryBo = new TrainCyjGoodsQryBo();
        List<Long> goodsIds = reqBO.getItemDoList().stream().map(TrainCyjOrderItemBo::getGoodsId).distinct().collect(Collectors.toList());
        trainCyjGoodsQryBo.setGoodsIds(goodsIds);
        this.trainCyjGoodsModel.queryGoodsList(trainCyjGoodsQryBo);
        TrainCyjUserQryBo trainCyjUserQryBo = new TrainCyjUserQryBo();
        trainCyjUserQryBo.setUserId(reqBO.getCreateUserId());
        this.trainCyjUserModel.queryUserDetail(trainCyjUserQryBo);
        TrainCyjOrderDo trainCyjOrderDo = (TrainCyjOrderDo)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), TrainCyjOrderDo.class);
        this.trainCyjOrderModel.createOrder(trainCyjOrderDo);
        return rsqBo;
    }

    public void validParam(TrainCyjCreateOrderReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getOrderNo())) {
            throw new ZTBusinessException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderName())) {
            throw new ZTBusinessException("\u8ba2\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderMoney() == null) {
            throw new ZTBusinessException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getItemDoList())) {
            throw new ZTBusinessException("\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (TrainCyjOrderItemBo bo : reqBo.getItemDoList()) {
            if (bo.getGoodsId() == null) {
                throw new ZTBusinessException("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getGoodsPrice() == null) {
                throw new ZTBusinessException("\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getCount() == null) {
                throw new ZTBusinessException("\u8d2d\u4e70\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            bo.setTotalMoney(bo.getGoodsPrice().multiply(BigDecimal.valueOf(bo.getCount().intValue())));
        }
    }

    @PostMapping(value={"qryOrderDetail"})
    public TrainCyjQryOrderDetailRsqBo qryOrderDetail(@RequestBody TrainCyjQryOrderDetailReqBo reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new ZTBusinessException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TrainCyjOrderQryBo trainCyjOrderQryBo = (TrainCyjOrderQryBo)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), TrainCyjOrderQryBo.class);
        TrainCyjOrderDo trainCyjOrderDo = this.trainCyjOrderModel.queryOrderDetail(trainCyjOrderQryBo);
        if (trainCyjOrderDo == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u4e3a\u7a7a");
        }
        TrainCyjQryOrderDetailRsqBo rsqBo = JsonUtil.js(this.trainCyjOrderModel.queryOrderDetail(trainCyjOrderQryBo), TrainCyjQryOrderDetailRsqBo.class);
        TrainCyjGoodsQryBo trainCyjGoodsQryBo = new TrainCyjGoodsQryBo();
        List<Long> goodsIds = trainCyjOrderDo.getItemDoList().stream().map(TrainCyjOrderItem::getGoodsId).distinct().collect(Collectors.toList());
        trainCyjGoodsQryBo.setGoodsIds(goodsIds);
        List<TrainCyjGoodsDo> goodsList = this.trainCyjGoodsModel.queryGoodsList(trainCyjGoodsQryBo);
        rsqBo.setGoodsList(JSON.parseArray((String)JSONObject.toJSONString(goodsList), TrainCyjGoodsBo.class));
        TrainCyjUserQryBo trainCyjUserQryBo = new TrainCyjUserQryBo();
        trainCyjUserQryBo.setUserId(trainCyjOrderDo.getCreateUserId());
        TrainCyjUserDo trainCyjUserDo = this.trainCyjUserModel.queryUserDetail(trainCyjUserQryBo);
        rsqBo.setUserInfo((TrainCyjUserBo)JSON.parseObject((String)JSONObject.toJSONString((Object)trainCyjUserDo), TrainCyjUserBo.class));
        return rsqBo;
    }
}

