/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.train.constants.TrainHWRspConstant;
import com.tydic.train.model.commodity.TrainHWCommodityDo;
import com.tydic.train.model.commodity.TrainHWCommodityModel;
import com.tydic.train.model.order.TrainHWOrderCreateDo;
import com.tydic.train.model.order.TrainHWOrderModel;
import com.tydic.train.model.user.TrainHWUserDo;
import com.tydic.train.model.user.TrainHWUserModel;
import com.tydic.train.service.order.TrainHWOrderQryService;
import com.tydic.train.service.order.bo.TrainHWOrderGoodsBo;
import com.tydic.train.service.order.bo.TrainHWOrderQryReqBO;
import com.tydic.train.service.order.bo.TrainHWOrderQryRspBO;
import com.tydic.train.utils.JsonUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.order.TrainHWOrderQryService"})
public class TrainHWOrderQryServiceImpl
implements TrainHWOrderQryService {
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;
    @Autowired
    private TrainHWUserModel trainHWUserModel;
    @Autowired
    private TrainHWCommodityModel trainHWCommodityModel;

    @PostMapping(value={"qryOrder"})
    public TrainHWOrderQryRspBO qryOrder(@RequestBody TrainHWOrderQryReqBO reqBO) {
        TrainHWOrderCreateDo createDo = this.trainHWOrderModel.qryOrder(reqBO.getOrderId());
        TrainHWOrderQryRspBO rspBO = JsonUtil.js((Object)createDo, TrainHWOrderQryRspBO.class);
        if (!CollectionUtils.isEmpty(createDo.getItemBos())) {
            List<Long> skuIds = createDo.getItemBos().stream().map(e -> e.getGoodsId()).collect(Collectors.toList());
            TrainHWCommodityDo hwCommodityDo = this.trainHWCommodityModel.qryGoodsByIds(skuIds);
            List goodsBos = hwCommodityDo.getCommoditySubBoList().stream().map(e -> (TrainHWOrderGoodsBo)JSONObject.parseObject((String)JSON.toJSONString((Object)e), TrainHWOrderGoodsBo.class)).collect(Collectors.toList());
            rspBO.setSkuList(goodsBos);
        }
        TrainHWUserDo trainHWUserDo = this.trainHWUserModel.qryUserById(rspBO.getCreateUserId());
        rspBO.setOrderStatusStr(TrainHWRspConstant.OrderStatusEnum.getTranslation((int)rspBO.getOrderStatus()));
        rspBO.setOrgId(trainHWUserDo.getOrgId());
        rspBO.setOrgName(trainHWUserDo.getOrgName());
        rspBO.setOrgCode(trainHWUserDo.getOrgCode());
        return rspBO;
    }
}

