/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.order;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.order.TrainLHLOrderDO;
import com.tydic.train.model.order.TrainLHLOrderModel;
import com.tydic.train.service.order.TrainLHLOrderCreateService;
import com.tydic.train.service.order.bo.TrainLHLOrderCreateReqBO;
import com.tydic.train.service.order.bo.TrainLHLOrderCreateRspBO;
import com.tydic.train.service.order.bo.TrainLHLOrderItemBO;
import com.tydic.train.utils.OrderGenerateIdUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.order.TrainLHLOrderCreateService"})
public class TrainLHLOrderCreateServiceImpl
implements TrainLHLOrderCreateService {
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private TrainLHLOrderModel trainLHLOrderModel;

    @PostMapping(value={"orderCreate"})
    public TrainLHLOrderCreateRspBO orderCreate(@RequestBody TrainLHLOrderCreateReqBO reqBO) {
        TrainLHLOrderCreateRspBO rspBO = new TrainLHLOrderCreateRspBO();
        this.judge(reqBO);
        TrainLHLOrderDO inserDO = new TrainLHLOrderDO();
        BeanUtils.copyProperties((Object)reqBO, (Object)inserDO);
        this.trainLHLOrderModel.insert(inserDO);
        rspBO.setOrderId(reqBO.getOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void judge(TrainLHLOrderCreateReqBO reqBO) {
        BigDecimal orderMoney = new BigDecimal(0);
        Date time = new Date(System.currentTimeMillis());
        reqBO.setOrderId(Long.valueOf(this.idUtil.nextId()));
        if (reqBO == null) {
            throw new ZTBusinessException("\u8ba2\u5355\u4e3b\u4f53\u65b0\u589e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderDetailInfo())) {
            throw new ZTBusinessException("\u8ba2\u5355\u8be6\u60c5\u65b0\u589e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderNo())) {
            throw new ZTBusinessException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderName())) {
            throw new ZTBusinessException("\u8ba2\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (TrainLHLOrderItemBO each : reqBO.getOrderDetailInfo()) {
            each.setItemId(Long.valueOf(this.idUtil.nextId()));
            each.setOrderId(reqBO.getOrderId());
            if (each.getGoodsId() == null) {
                throw new ZTBusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getGoodsPrice() == null) {
                throw new ZTBusinessException("\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getCount() == null) {
                throw new ZTBusinessException("\u8d2d\u4e70\u6570\u91cf");
            }
            if (each.getTotalMoney() == null) {
                each.setTotalMoney(each.getGoodsPrice().multiply(new BigDecimal(each.getCount())));
            }
            orderMoney = orderMoney.add(each.getTotalMoney());
            each.setDelFlag(Integer.valueOf(0));
        }
        reqBO.setOrderMoney(orderMoney);
        if (reqBO.getCreateUserId() == null) {
            reqBO.setCreateUserId(reqBO.getUserId());
            reqBO.setCreateUserName(reqBO.getUsername());
        }
        reqBO.setCreateTime(time);
        reqBO.setDelFlag(Integer.valueOf(0));
    }
}

