/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.goods.TrainYyfGoodsDO;
import com.tydic.train.model.goods.TrainYyfGoodsModel;
import com.tydic.train.model.order.TrainYyfOrderDo;
import com.tydic.train.model.order.TrainYyfOrderItemDo;
import com.tydic.train.model.order.TrainYyfOrderModel;
import com.tydic.train.model.user.TrainYyfUserDO;
import com.tydic.train.model.user.TrainYyfUserModel;
import com.tydic.train.service.order.TrainYyfCreateOrderService;
import com.tydic.train.service.order.bo.TrainYyfCreateOrderReqBO;
import com.tydic.train.service.order.bo.TrainYyfCreateOrderRspBO;
import com.tydic.train.utils.TrainTfqIdUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.order.TrainYyfCreateOrderService"})
public class TrainYyfCreateOrderServiceImpl
implements TrainYyfCreateOrderService {
    @Autowired
    private TrainYyfOrderModel trainYyfOrderModel;
    @Autowired
    private TrainYyfUserModel trainYyfUserModel;
    @Autowired
    private TrainYyfGoodsModel trainYyfGoodsModel;

    @PostMapping(value={"createOrder"})
    public TrainYyfCreateOrderRspBO createOrder(@RequestBody TrainYyfCreateOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        TrainYyfCreateOrderRspBO rspBo = new TrainYyfCreateOrderRspBO();
        TrainYyfUserDO userDO = new TrainYyfUserDO();
        userDO.setUserId(reqBO.getUserId());
        TrainYyfUserDO userDetail = this.trainYyfUserModel.qryUserDetail(userDO);
        if (ObjectUtil.isEmpty((Object)userDetail)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u7528\u6237\u4e0d\u5b58\u5728");
            return rspBo;
        }
        TrainYyfGoodsDO goodsDO = new TrainYyfGoodsDO();
        goodsDO.setGoodsId(reqBO.getGoodsId());
        TrainYyfGoodsDO goodsDetail = this.trainYyfGoodsModel.qryGoodsDetail(goodsDO);
        if (ObjectUtil.isEmpty((Object)goodsDetail)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5546\u54c1\u4e0d\u5b58\u5728");
            return rspBo;
        }
        TrainYyfOrderDo insertOrderDO = new TrainYyfOrderDo();
        insertOrderDO.setOrderNo(TrainTfqIdUtil.nextId() + "YYF");
        insertOrderDO.setOrderName("YYF\u7684\u8ba2\u5355");
        insertOrderDO.setOrderMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(reqBO.getCount())));
        insertOrderDO.setCreateUserId(userDetail.getUserId());
        insertOrderDO.setCreateUserName(userDetail.getUserName());
        insertOrderDO.setCreateTime(new Date());
        insertOrderDO.setDelFlag(0);
        ArrayList<TrainYyfOrderItemDo> insertOrderItemDOList = new ArrayList<TrainYyfOrderItemDo>();
        TrainYyfOrderItemDo insertOrderItemDO = new TrainYyfOrderItemDo();
        insertOrderItemDO.setItemId(TrainTfqIdUtil.nextId());
        insertOrderItemDO.setCount(reqBO.getCount());
        insertOrderItemDO.setGoodsId(goodsDetail.getGoodsId());
        insertOrderItemDO.setTotalMoney(goodsDetail.getGoodsPrice());
        insertOrderItemDO.setDelFlag(0);
        insertOrderItemDOList.add(insertOrderItemDO);
        insertOrderDO.setItemList(insertOrderItemDOList);
        Long orderId = this.trainYyfOrderModel.insertOrder(insertOrderDO);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setOrderId(orderId);
        return rspBo;
    }

    private void verifyParam(TrainYyfCreateOrderReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUserId())) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getGoodsId())) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u5546\u54c1ID\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCount())) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u8d2d\u4e70\u6570\u91cf\u4e3a\u7a7a");
        }
    }
}

