/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.pay;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.constants.TrainHWRspConstant;
import com.tydic.train.model.order.TrainHWOrderModel;
import com.tydic.train.model.order.qrybo.TrainHWOrderChangeQryBO;
import com.tydic.train.model.workflow.TrainHWProcessTaskDo;
import com.tydic.train.model.workflow.TrainHWProcessTaskModel;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessTaskQryBo;
import com.tydic.train.service.pay.TrainHWPayService;
import com.tydic.train.service.pay.bo.TrainHWPayReqBO;
import com.tydic.train.service.pay.bo.TrainHWPayRspBO;
import com.tydic.train.service.pay.bo.TrainHWProcessTaskBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.pay.TrainHWPayService"})
public class TrainHWPayServiceImpl
implements TrainHWPayService {
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;
    @Autowired
    private TrainHWProcessTaskModel trainHWProcessTaskModel;

    @PostMapping(value={"pay"})
    public TrainHWPayRspBO pay(@RequestBody TrainHWPayReqBO reqBO) {
        this.validate(reqBO);
        TrainHWProcessTaskBo taskBo = this.validateProcess(reqBO);
        if (TrainHWRspConstant.AUDIT_RESULT_FLAG.pass.equals(reqBO.getAuditResult())) {
            this.dealOrderStatusChange(reqBO);
        }
        TrainHWPayRspBO rspBO = new TrainHWPayRspBO();
        rspBO.setTaskId(taskBo.getTaskId());
        return rspBO;
    }

    private void dealOrderStatusChange(TrainHWPayReqBO reqBO) {
        TrainHWOrderChangeQryBO orderChangeQryBO = new TrainHWOrderChangeQryBO();
        orderChangeQryBO.setOrderStatus(TrainHWRspConstant.ORDER_STATUS.TO_BE_SHIPPED);
        orderChangeQryBO.setOrderId(reqBO.getOrderId());
        this.trainHWOrderModel.updateOrderStatus(orderChangeQryBO);
    }

    private TrainHWProcessTaskBo validateProcess(TrainHWPayReqBO reqBO) {
        TrainHWProcessTaskQryBo taskQryBo = new TrainHWProcessTaskQryBo();
        taskQryBo.setObjId(reqBO.getOrderId().toString());
        taskQryBo.setPendingUserId(reqBO.getUserId().toString());
        TrainHWProcessTaskDo taskDo = this.trainHWProcessTaskModel.qryProcees(taskQryBo);
        if ("0".equals(taskDo.getCode())) {
            if (CollectionUtils.isEmpty(taskDo.getTaskBoList()) || taskDo.getTaskBoList().size() > 1) {
                throw new ZTBusinessException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728 \u6216\u8005 \u5b58\u5728\u591a\u6761\u6fc0\u6d3b\u7684\u5b9e\u4f8b");
            }
            return taskDo.getTaskBoList().get(0);
        }
        throw new ZTBusinessException("\u6d41\u7a0b\u4efb\u52a1\u5b9e\u4f8b\u6821\u9a8c\u5931\u8d25");
    }

    private void validate(TrainHWPayReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            throw new ZTBusinessException("\u53c2\u6570 orderId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAuditResult())) {
            throw new ZTBusinessException("\u53c2\u6570 auditResult \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUserId())) {
            throw new ZTBusinessException("\u53c2\u6570 userId \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

