/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.tfquoc;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqCreateShipOrderDO;
import com.tydic.train.service.tfquoc.api.TrainTfqCreateShipOrderService;
import com.tydic.train.service.tfquoc.bo.TrainTfqCreateShipOrderReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqCreateShipOrderRspBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqShipOrderItemBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.tfquoc.api.TrainTfqCreateShipOrderService"})
public class TrainTfqCreateShipOrderServiceImpl
implements TrainTfqCreateShipOrderService {
    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @PostMapping(value={"createShipOrder"})
    public TrainTfqCreateShipOrderRspBO createShipOrder(@RequestBody TrainTfqCreateShipOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        TrainTfqCreateShipOrderDO trainTfqCreateShipOrderDO = TrainTfqRuUtil.js(reqBO, TrainTfqCreateShipOrderDO.class);
        this.trainTfqOrderModel.createShipOrder(trainTfqCreateShipOrderDO);
        return TrainTfqRuUtil.success(TrainTfqCreateShipOrderRspBO.class);
    }

    private void verifyParam(TrainTfqCreateShipOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getShipOrderItemList())) {
            throw new ZTBusinessException("\u5165\u53c2\u53d1\u8d27\u660e\u7ec6\u4e0d\u80fd\u4e3anull");
        }
        for (TrainTfqShipOrderItemBO itemBO : reqBO.getShipOrderItemList()) {
            if (itemBO.getShipCount() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3anull");
            }
            if (itemBO.getShipCount() <= 0) {
                throw new ZTBusinessException("\u5165\u53c2\u53d1\u8d27\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6570");
            }
            if (itemBO.getItemId() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355\u660e\u7ec6id\u4e0d\u80fd\u4e3anull");
        }
    }
}

