/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.model.gdx.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.gdx.task.TrainGdxProcessInstModel;
import com.tydic.train.repository.gdx.TrainGdxProcessInstRepository;
import com.tydic.train.repository.gdx.TrainGdxTaskInstRepository;
import com.tydic.train.service.gdx.task.bo.TrainGdxProcessInstBo;
import com.tydic.train.service.gdx.task.bo.TrainGdxTaskInstBo;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TrainGdxProcessInstModelImpl
implements TrainGdxProcessInstModel {
    private final TrainGdxProcessInstRepository trainGdxProcessInstRepository;
    private final TrainGdxTaskInstRepository trainGdxTaskInstRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createTask(TrainGdxProcessInstBo processInstBo) {
        this.trainGdxProcessInstRepository.createOrUpdate(processInstBo);
        this.trainGdxTaskInstRepository.insertOrUpdateBatch(processInstBo.getProcInstId(), processInstBo.getTaskInstList());
    }

    @Override
    public TrainGdxProcessInstBo queryTask(String taskId) {
        TrainGdxTaskInstBo trainGdxTaskInstBo = this.trainGdxTaskInstRepository.queryByTaskId(taskId);
        if (trainGdxTaskInstBo == null) {
            return null;
        }
        TrainGdxProcessInstBo trainGdxProcessInstBo = this.trainGdxProcessInstRepository.queryByFlowId(trainGdxTaskInstBo.getProcInstId());
        List<TrainGdxTaskInstBo> trainGdxTaskInstBos = this.trainGdxTaskInstRepository.queryByFlowId(trainGdxTaskInstBo.getProcInstId());
        trainGdxProcessInstBo.setTaskInstList(trainGdxTaskInstBos);
        return trainGdxProcessInstBo;
    }

    @Override
    public void updateFlowTask(TrainGdxProcessInstBo processInstBo) {
        this.trainGdxProcessInstRepository.createOrUpdate(processInstBo);
        if (CollectionUtil.isNotEmpty((Collection)processInstBo.getTaskInstList())) {
            for (TrainGdxTaskInstBo trainGdxTaskInstBo : processInstBo.getTaskInstList()) {
                this.trainGdxTaskInstRepository.update(trainGdxTaskInstBo);
            }
        }
    }

    @Override
    public void updateTask(List<TrainGdxTaskInstBo> taskInstList) {
        if (CollectionUtil.isNotEmpty(taskInstList)) {
            for (TrainGdxTaskInstBo trainGdxTaskInstBo : taskInstList) {
                this.trainGdxTaskInstRepository.update(trainGdxTaskInstBo);
            }
        }
    }

    @Override
    public TrainGdxProcessInstBo queryFlowTask(String flowInstId, String objId) {
        if (StrUtil.isEmpty((CharSequence)flowInstId) && StrUtil.isEmpty((CharSequence)objId)) {
            throw new ZTBusinessException("\u53c2\u6570\u9519\u8bef");
        }
        TrainGdxProcessInstBo trainGdxProcessInstBo = StrUtil.isNotBlank((CharSequence)objId) ? this.trainGdxProcessInstRepository.queryByObjId(objId) : this.trainGdxProcessInstRepository.queryByFlowId(flowInstId);
        if (trainGdxProcessInstBo == null) {
            throw new ZTBusinessException("\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        List<TrainGdxTaskInstBo> trainGdxTaskInstBos = this.trainGdxTaskInstRepository.queryByFlowId(trainGdxProcessInstBo.getProcInstId());
        trainGdxProcessInstBo.setTaskInstList(trainGdxTaskInstBos);
        return trainGdxProcessInstBo;
    }

    @Override
    public void deleteBatchTask(List<String> taskIds) {
        this.trainGdxTaskInstRepository.deleteBatchTask(taskIds);
    }

    public TrainGdxProcessInstModelImpl(TrainGdxProcessInstRepository trainGdxProcessInstRepository, TrainGdxTaskInstRepository trainGdxTaskInstRepository) {
        this.trainGdxProcessInstRepository = trainGdxProcessInstRepository;
        this.trainGdxTaskInstRepository = trainGdxTaskInstRepository;
    }
}

