/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.train.model.xsd.order.TrainXsdOrderModel;
import com.tydic.train.model.xsd.order.sub.TrainXsdOrderDo;
import com.tydic.train.model.xsd.order.sub.TrainXsdOrderItemDo;
import com.tydic.train.service.course.TrainXsdCreateOrderService;
import com.tydic.train.service.course.bo.TrainXsdCreateOrderGoodsBo;
import com.tydic.train.service.course.bo.TrainXsdCreateOrderReqBO;
import com.tydic.train.service.course.bo.TrainXsdCreateOrderRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.course.TrainXsdCreateOrderService"})
public class TrainXsdCreateOrderServiceImpl
implements TrainXsdCreateOrderService {
    @Autowired
    private TrainXsdOrderModel trainXsdOrderModel;

    @PostMapping(value={"createOrder"})
    public TrainXsdCreateOrderRspBO createOrder(@RequestBody TrainXsdCreateOrderReqBO reqBO) {
        TrainXsdCreateOrderRspBO rspBO = new TrainXsdCreateOrderRspBO();
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getGoodsInfo())) {
            throw new ZTBusinessException("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        }
        for (TrainXsdCreateOrderGoodsBo trainXsdCreateOrderGoodsBo : reqBO.getGoodsInfo()) {
            if (trainXsdCreateOrderGoodsBo.getGoodsId() == null) {
                throw new ZTBusinessException("\u5546\u54c1ID\u4e3a\u7a7a");
            }
            if (trainXsdCreateOrderGoodsBo.getCount() == null) {
                throw new ZTBusinessException("\u8d2d\u4e70\u6570\u91cf\u4e3a\u7a7a");
            }
            if (trainXsdCreateOrderGoodsBo.getGoodsPrice() != null) continue;
            throw new ZTBusinessException("\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a");
        }
        Long orderId = Sequence.getInstance().nextId();
        TrainXsdOrderDo trainXsdOrderDo = new TrainXsdOrderDo();
        trainXsdOrderDo.setOrderId(orderId);
        trainXsdOrderDo.setOrderNo("\u8ba2\u5355\u7f16\u53f7");
        trainXsdOrderDo.setOrderName("\u8ba2\u5355\u540d\u79f0");
        trainXsdOrderDo.setCreateUserId(reqBO.getUserId());
        trainXsdOrderDo.setCreateUserName(reqBO.getUserName());
        trainXsdOrderDo.setCreateTime(new Date());
        trainXsdOrderDo.setDelFlag(0);
        BigDecimal orderMoney = BigDecimal.ZERO;
        ArrayList<TrainXsdOrderItemDo> itemDos = new ArrayList<TrainXsdOrderItemDo>();
        for (TrainXsdCreateOrderGoodsBo trainXsdCreateOrderGoodsBo : reqBO.getGoodsInfo()) {
            TrainXsdOrderItemDo trainXsdOrderItemDo = new TrainXsdOrderItemDo();
            trainXsdOrderItemDo.setGoodsId(trainXsdCreateOrderGoodsBo.getGoodsId());
            trainXsdOrderItemDo.setCount(trainXsdCreateOrderGoodsBo.getCount());
            trainXsdOrderItemDo.setGoodsPrice(trainXsdCreateOrderGoodsBo.getGoodsPrice());
            trainXsdOrderItemDo.setItemId(Sequence.getInstance().nextId());
            trainXsdOrderItemDo.setOrderId(trainXsdOrderDo.getOrderId());
            trainXsdOrderItemDo.setTotalMoney(trainXsdCreateOrderGoodsBo.getGoodsPrice().multiply(new BigDecimal(String.valueOf(trainXsdCreateOrderGoodsBo.getCount()))));
            trainXsdOrderItemDo.setDelFlag(0);
            orderMoney = orderMoney.add(trainXsdOrderItemDo.getTotalMoney());
            itemDos.add(trainXsdOrderItemDo);
        }
        trainXsdOrderDo.setOrderMoney(orderMoney);
        trainXsdOrderDo.setOrderItemInfo(itemDos);
        this.trainXsdOrderModel.createOrder(trainXsdOrderDo);
        rspBO.setOrderId(orderId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

