/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.task;

import com.tydic.dyc.base.utils.JUtil;
import com.tydic.train.constants.TrainLHLConstant;
import com.tydic.train.constants.TrainLHLOrderStatusEnum;
import com.tydic.train.model.order.TrainLHLOrderDO;
import com.tydic.train.model.order.TrainLHLOrderItemDO;
import com.tydic.train.model.order.TrainLHLOrderModel;
import com.tydic.train.model.shiporder.TrainLHLShipOrderDO;
import com.tydic.train.model.shiporder.TrainLHLShipOrderItemDO;
import com.tydic.train.model.shiporder.TrainLHLShipOrderModel;
import com.tydic.train.model.task.TrainLHLProcessInstDO;
import com.tydic.train.model.task.TrainLHLTaskInstDO;
import com.tydic.train.model.task.TrainLHLTaskModel;
import com.tydic.train.service.course.exception.BaseBusinessException;
import com.tydic.train.service.task.TrainLHLTaskDealService;
import com.tydic.train.service.task.bo.TrainLHLTaskBO;
import com.tydic.train.service.task.bo.TrainLHLTaskDealReqBO;
import com.tydic.train.service.task.bo.TrainLHLTaskDealRspBO;
import com.tydic.train.utils.OrderGenerateIdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.task.TrainLHLTaskDealService"})
public class TrainLHLTaskDealServiceImpl
implements TrainLHLTaskDealService {
    @Autowired
    private TrainLHLTaskModel trainLHLTaskModel;
    @Autowired
    private TrainLHLOrderModel trainLHLOrderModel;
    @Autowired
    private TrainLHLShipOrderModel trainLHLShipOrderModel;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    @PostMapping(value={"dealTask"})
    public TrainLHLTaskDealRspBO dealTask(@RequestBody TrainLHLTaskDealReqBO reqBO) {
        TrainLHLTaskDealRspBO rspBO = new TrainLHLTaskDealRspBO();
        TrainLHLProcessInstDO temp = new TrainLHLProcessInstDO();
        temp.setProcInstId(reqBO.getProcInstId());
        List<TrainLHLProcessInstDO> processList = this.trainLHLTaskModel.getProcessList(temp);
        if (CollectionUtils.isEmpty(processList)) {
            this.trainLHLTaskModel.insertProcess((TrainLHLProcessInstDO)JUtil.js((Object)reqBO, TrainLHLProcessInstDO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTaskInstList())) {
            for (TrainLHLTaskBO each : reqBO.getTaskInstList()) {
                TrainLHLTaskInstDO js = (TrainLHLTaskInstDO)JUtil.js((Object)each, TrainLHLTaskInstDO.class);
                js.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.ACTIVATION);
                this.trainLHLTaskModel.insert(js);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"updateTaskAndOrder"})
    public TrainLHLTaskDealRspBO updateTaskAndOrder(@RequestBody TrainLHLTaskDealReqBO reqBO) {
        TrainLHLOrderDO orderDO;
        TrainLHLTaskDealRspBO rspBO = new TrainLHLTaskDealRspBO();
        TrainLHLProcessInstDO trainLHLTaskInstDO = new TrainLHLProcessInstDO();
        trainLHLTaskInstDO.setProcInstId(reqBO.getProcInstId());
        List<TrainLHLProcessInstDO> processList = this.trainLHLTaskModel.getProcessList(trainLHLTaskInstDO);
        if (CollectionUtils.isEmpty(processList)) {
            throw new BaseBusinessException("8888", "\u4e2d\u5fc3\u5c42\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        if (reqBO.getIsFinish() == 0) {
            orderDO = new TrainLHLOrderDO();
            orderDO.setOrderId(Long.parseLong(processList.get(0).getObjId()));
            orderDO.setOrderStatus(TrainLHLOrderStatusEnum.getStatusByStepCode((String)reqBO.getNextStepCode()));
            if (reqBO.getAcceptFlag() != null && reqBO.getAcceptFlag() == 1) {
                orderDO.setOrderStatus(TrainLHLOrderStatusEnum.O_005.getOrderStatus());
                orderDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.DEL);
            } else {
                orderDO.setOrderStatus(TrainLHLOrderStatusEnum.O_004.getOrderStatus());
                this.createShipOrder(Long.parseLong(processList.get(0).getObjId()), reqBO);
            }
            this.trainLHLOrderModel.updateBy(orderDO);
        } else {
            orderDO = new TrainLHLOrderDO();
            orderDO.setOrderId(Long.parseLong(processList.get(0).getObjId()));
            orderDO.setOrderStatus(TrainLHLOrderStatusEnum.getStatusByStepCode((String)reqBO.getNextStepCode()));
            this.trainLHLOrderModel.updateBy(orderDO);
        }
        if (reqBO.getIsFinish() == 1) {
            TrainLHLProcessInstDO trainLHLProcessInstDO = new TrainLHLProcessInstDO();
            trainLHLProcessInstDO.setProcInstId(reqBO.getProcInstId());
            trainLHLProcessInstDO.setIsFinish(reqBO.getIsFinish());
            this.trainLHLTaskModel.updateByProcess(trainLHLProcessInstDO);
            TrainLHLTaskInstDO taskInstDO = new TrainLHLTaskInstDO();
            taskInstDO.setProcInstId(reqBO.getProcInstId());
            taskInstDO.setStepStatus(reqBO.getIsFinish());
            this.trainLHLTaskModel.updateBy(taskInstDO);
        } else {
            TrainLHLTaskInstDO taskInstDO = new TrainLHLTaskInstDO();
            taskInstDO.setTaskId(reqBO.getTaskId().toString());
            taskInstDO.setStepStatus(TrainLHLConstant.PROSECC_TASK_STATE.done);
            this.trainLHLTaskModel.updateBy(taskInstDO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"stopTask"})
    public TrainLHLTaskDealRspBO stopTask(@RequestBody List<String> procInstIds) {
        TrainLHLTaskDealRspBO rspBO = new TrainLHLTaskDealRspBO();
        if (CollectionUtils.isEmpty(procInstIds)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        TrainLHLProcessInstDO trainLHLTaskInstDO = new TrainLHLProcessInstDO();
        trainLHLTaskInstDO.setProcInstIds(procInstIds);
        List<TrainLHLProcessInstDO> processList = this.trainLHLTaskModel.getProcessList(trainLHLTaskInstDO);
        if (CollectionUtils.isEmpty(processList)) {
            throw new BaseBusinessException("8888", "\u4e2d\u5fc3\u5c42\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        TrainLHLOrderDO trainLHLOrderDO = new TrainLHLOrderDO();
        trainLHLOrderDO.setOrderIds(processList.stream().map(e -> Long.parseLong(e.getObjId())).collect(Collectors.toList()));
        trainLHLOrderDO.setOrderStatus(TrainLHLOrderStatusEnum.O_006.getOrderStatus());
        trainLHLOrderDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.DEL);
        this.trainLHLOrderModel.updateBy(trainLHLOrderDO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void createShipOrder(Long orderId, TrainLHLTaskDealReqBO reqBO) {
        TrainLHLOrderDO trainLHLOrderDO = this.trainLHLOrderModel.qryOrder(orderId);
        TrainLHLShipOrderDO inserDO = new TrainLHLShipOrderDO();
        BeanUtils.copyProperties((Object)trainLHLOrderDO, (Object)inserDO);
        inserDO.setShipOrderId(this.idUtil.nextId());
        inserDO.setShipOrderNo("lhl-HFD-" + System.currentTimeMillis());
        inserDO.setShipUserId(reqBO.getUserId());
        inserDO.setShipUserName(reqBO.getUsername());
        inserDO.setShipTime(new Date(System.currentTimeMillis()));
        inserDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.ACTIVATION);
        ArrayList<TrainLHLShipOrderItemDO> itemList = new ArrayList<TrainLHLShipOrderItemDO>();
        for (TrainLHLOrderItemDO each : trainLHLOrderDO.getOrderDetailInfo()) {
            TrainLHLShipOrderItemDO item = (TrainLHLShipOrderItemDO)JUtil.js((Object)each, TrainLHLShipOrderItemDO.class);
            item.setShipItemId(this.idUtil.nextId());
            item.setShipOrderId(inserDO.getShipOrderId());
            item.setOrderId(each.getOrderId());
            item.setItemId(each.getItemId());
            item.setGoodsId(each.getGoodsId());
            item.setShipCount(each.getCount());
            item.setCount(each.getCount());
            item.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.ACTIVATION);
            itemList.add(item);
        }
        this.trainLHLShipOrderModel.insert(inserDO);
    }
}

