/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.tfquoc;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.utils.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqCreateOrderDO;
import com.tydic.train.service.tfquoc.api.TrainTfqCreateOrderService;
import com.tydic.train.service.tfquoc.bo.TrainTfqCreateOrderReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqCreateOrderRspBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqGoodsInfoBO;
import java.math.BigDecimal;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.tfquoc.api.TrainTfqCreateOrderService"})
public class TrainTfqCreateOrderServiceImpl
implements TrainTfqCreateOrderService {
    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @PostMapping(value={"createOrder"})
    public TrainTfqCreateOrderRspBO createOrder(@RequestBody TrainTfqCreateOrderReqBO reqBO) {
        TrainTfqCreateOrderDO trainTfqCreateOrderDO = (TrainTfqCreateOrderDO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), TrainTfqCreateOrderDO.class);
        TrainTfqCreateOrderDO order = this.trainTfqOrderModel.createOrder(trainTfqCreateOrderDO);
        TrainTfqCreateOrderRspBO rspBO = new TrainTfqCreateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setOrderId(order.getOrderId());
        rspBO.setOrderNo(order.getOrderNo());
        return rspBO;
    }

    private void verifyParam(TrainTfqCreateOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getCreateUserId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u3010\u521b\u5efa\u4ebaid\u3011\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isBlank((String)reqBO.getCreateUserName())) {
            throw new ZTBusinessException("\u5165\u53c2\u3010\u521b\u5efa\u4eba\u540d\u79f0\u3011\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getGoodsInfoList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3anull");
        }
        for (TrainTfqGoodsInfoBO item : reqBO.getGoodsInfoList()) {
            if (item.getGoodsId() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355\u660e\u7ec6\u3010\u5546\u54c1id\u3011\u4e0d\u80fd\u4e3anull");
            }
            if (item.getGoodsPrice() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355\u660e\u7ec6\u3010\u5546\u54c1\u4ef7\u683c\u3011\u4e0d\u80fd\u4e3anull");
            }
            if (item.getGoodsPrice().compareTo(BigDecimal.ZERO) <= 0) {
                throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355\u660e\u7ec6\u3010\u5546\u54c1\u4ef7\u683c\u3011\u5fc5\u987b\u4e3a\u6b63\u6570");
            }
            if (item.getCount() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355\u660e\u7ec6\u3010\u8d2d\u4e70\u6570\u91cf\u3011\u4e0d\u80fd\u4e3anull");
            }
            if (item.getCount() > 0) continue;
            throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355\u660e\u7ec6\u3010\u8d2d\u4e70\u6570\u91cf\u3011\u5fc5\u987b\u4e3a\u6b63\u6570");
        }
    }
}

