/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.tfquoc;

import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.qrybo.TrainTfqTaskInstQryBO;
import com.tydic.train.model.tfquoc.sub.TrainTfqProcessInstDO;
import com.tydic.train.model.tfquoc.sub.TrainTfqTaskInstDO;
import com.tydic.train.service.tfquoc.api.TrainTfqDealFlowService;
import com.tydic.train.service.tfquoc.bo.TrainTfqDealFlowReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqDealFlowRspBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqTaskInstBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.tfquoc.api.TrainTfqDealFlowService"})
public class TrainTfqDealFlowServiceImpl
implements TrainTfqDealFlowService {
    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @PostMapping(value={"dealFlow"})
    public TrainTfqDealFlowRspBO dealFlow(@RequestBody TrainTfqDealFlowReqBO reqBO) {
        if (reqBO.getIsfinish() == 1) {
            this.updateProcessInst(reqBO);
            TrainTfqTaskInstQryBO trainTfqTaskInstQryBO = new TrainTfqTaskInstQryBO();
            trainTfqTaskInstQryBO.setProcInstId(reqBO.getProcInstId());
            trainTfqTaskInstQryBO.setStepStatus(reqBO.getIsfinish());
            trainTfqTaskInstQryBO.setQryStepStatus(0);
            trainTfqTaskInstQryBO.setDealTime(new Date());
            this.trainTfqOrderModel.updateBatchByTaskId(trainTfqTaskInstQryBO);
        } else {
            TrainTfqProcessInstDO trainTfqProcessInstDO = new TrainTfqProcessInstDO();
            trainTfqProcessInstDO.setProcInstId(reqBO.getProcInstId());
            TrainTfqProcessInstDO processInst = this.trainTfqOrderModel.getProcessInst(trainTfqProcessInstDO);
            if (processInst == null) {
                TrainTfqProcessInstDO addProcessInst = new TrainTfqProcessInstDO();
                addProcessInst.setProcInstId(reqBO.getProcInstId());
                addProcessInst.setProcKey(reqBO.getProcDefKey());
                addProcessInst.setParentProcInstId(reqBO.getParentProcInstId());
                addProcessInst.setProcDefId(reqBO.getProcDefId());
                addProcessInst.setIsFinish(0);
                addProcessInst.setObjId(reqBO.getOrderId().toString());
                addProcessInst.setObjType(1);
                addProcessInst.setStepCode(reqBO.getStepCode());
                addProcessInst.setStepName(reqBO.getStepName());
                addProcessInst.setDelFlag(0);
                this.trainTfqOrderModel.insertBatchProcessIns(Collections.singletonList(addProcessInst));
            } else {
                this.updateProcessInst(reqBO);
                if (!CollectionUtils.isEmpty((Collection)reqBO.getOverList())) {
                    List<String> list = reqBO.getOverList().stream().map(TrainTfqTaskInstBO::getTaskId).collect(Collectors.toList());
                    TrainTfqTaskInstQryBO trainTfqTaskInstQryBO = new TrainTfqTaskInstQryBO();
                    trainTfqTaskInstQryBO.setTaskIdList(list);
                    trainTfqTaskInstQryBO.setDealTime(new Date());
                    trainTfqTaskInstQryBO.setStepStatus(1);
                    this.trainTfqOrderModel.updateBatchByTaskId(trainTfqTaskInstQryBO);
                }
            }
        }
        this.addTask(reqBO);
        return TrainTfqRuUtil.success(TrainTfqDealFlowRspBO.class);
    }

    private void addTask(TrainTfqDealFlowReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTaskList())) {
            List<TrainTfqTaskInstDO> trainTfqTaskInstDOS = TrainTfqRuUtil.jsl(reqBO.getTaskList(), TrainTfqTaskInstDO.class);
            trainTfqTaskInstDOS.stream().forEach(taskInstDO -> {
                taskInstDO.setStepStatus(0);
                taskInstDO.setDelFlag(0);
            });
            this.trainTfqOrderModel.insertBatchTaskInst(trainTfqTaskInstDOS);
        }
    }

    private void updateProcessInst(TrainTfqDealFlowReqBO reqBO) {
        TrainTfqProcessInstDO trainTfqProcessInstDO = new TrainTfqProcessInstDO();
        trainTfqProcessInstDO.setProcInstId(reqBO.getProcInstId());
        trainTfqProcessInstDO.setIsFinish(reqBO.getIsfinish());
        trainTfqProcessInstDO.setProcDefId(reqBO.getProcDefId());
        trainTfqProcessInstDO.setStepCode(reqBO.getStepCode());
        trainTfqProcessInstDO.setStepName(reqBO.getStepName());
        this.trainTfqOrderModel.updateBatchProcessIns(Collections.singletonList(trainTfqProcessInstDO));
    }
}

