/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.train.service.zl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.zl.TrainZLGoodsDO;
import com.tydic.train.model.zl.TrainZLGoodsModel;
import com.tydic.train.model.zl.TrainZLOrderDO;
import com.tydic.train.model.zl.TrainZLOrderItemDO;
import com.tydic.train.model.zl.TrainZLOrderModel;
import com.tydic.train.model.zl.TrainZLUserDO;
import com.tydic.train.model.zl.TrainZLUserModel;
import com.tydic.train.service.zl.TrainZLCreateOrderService;
import com.tydic.train.service.zl.bo.TrainZLCreateOrderReqBO;
import com.tydic.train.service.zl.bo.TrainZLCreateOrderRspBO;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.train.service.zl.TrainZLCreateOrderService"})
public class TrainZLCreateOrderServiceImpl
implements TrainZLCreateOrderService {
    @Autowired
    private TrainZLUserModel trainZLUserModel;
    @Autowired
    private TrainZLGoodsModel trainZLGoodsModel;
    @Autowired
    private TrainZLOrderModel trainZLOrderModel;
    private static final Integer not_del = 0;

    @PostMapping(value={"createOrder"})
    public TrainZLCreateOrderRspBO createOrder(@RequestBody TrainZLCreateOrderReqBO reqBO) {
        this.paramVf(reqBO);
        TrainZLCreateOrderRspBO rspBO = new TrainZLCreateOrderRspBO();
        TrainZLUserDO userDO = new TrainZLUserDO();
        userDO.setUserId(reqBO.getUserId());
        TrainZLUserDO userDetail = this.trainZLUserModel.qryUserDetail(userDO);
        if (ObjectUtil.isEmpty((Object)userDetail)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7528\u6237\u4e0d\u5b58\u5728");
            return rspBO;
        }
        TrainZLGoodsDO goodsDO = new TrainZLGoodsDO();
        goodsDO.setGoodsId(reqBO.getGoodsId());
        TrainZLGoodsDO goodsDetail = this.trainZLGoodsModel.qryGoodsDetail(goodsDO);
        if (ObjectUtil.isEmpty((Object)goodsDetail)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u4e0d\u5b58\u5728");
            return rspBO;
        }
        TrainZLOrderDO insertOrderDO = new TrainZLOrderDO();
        insertOrderDO.setOrderName("\u8ba2\u5355\u540d\u79f0");
        insertOrderDO.setOrderMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(reqBO.getCount())));
        insertOrderDO.setCreateUserId(userDetail.getUserId());
        insertOrderDO.setCreateUserName(userDetail.getUserName());
        insertOrderDO.setCreateTime(new Date());
        insertOrderDO.setDelFlag(not_del);
        Long orderId = this.trainZLOrderModel.insertOrder(insertOrderDO);
        TrainZLOrderItemDO insertOrderItemDO = new TrainZLOrderItemDO();
        insertOrderItemDO.setOrderId(orderId);
        insertOrderItemDO.setGoodsId(goodsDetail.getGoodsId());
        insertOrderItemDO.setGoodsPrice(goodsDetail.getGoodsPrice());
        insertOrderItemDO.setCount(reqBO.getCount());
        insertOrderItemDO.setTotalMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(reqBO.getCount())));
        insertOrderItemDO.setDelFlag(not_del);
        this.trainZLOrderModel.insertOrderItem(insertOrderItemDO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setOrderId(orderId);
        return rspBO;
    }

    private void paramVf(TrainZLCreateOrderReqBO reqBO) {
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (reqBO.getGoodsId() == null) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u5546\u54c1ID\u4e3a\u7a7a");
        }
        if (reqBO.getCount() == null) {
            throw new ZTBusinessException("\u4e0b\u5355\u5165\u53c2\u8d2d\u4e70\u6570\u91cf\u4e3a\u7a7a");
        }
    }
}

