package com.tydic.train.model.gdx.order.impl;

import com.tydic.train.model.gdx.order.TrainGdxOrderModel;
import com.tydic.train.model.gdx.order.qrybo.TrainGdxOrderQryBo;
import com.tydic.train.repository.gdx.TrainGdxOrderItemRepository;
import com.tydic.train.repository.gdx.TrainGdxOrderRepository;
import com.tydic.train.service.gdx.order.bo.TrainGdxOrderBo;
import com.tydic.train.service.gdx.order.bo.TrainGdxOrderItemBo;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/28 16:30
 */
@Service
@RequiredArgsConstructor
public class TrainGdxOrderModelImpl implements TrainGdxOrderModel {

    private final TrainGdxOrderRepository trainGdxOrderRepository;

    private final TrainGdxOrderItemRepository trainGdxOrderItemRepository;


    @Override
    public TrainGdxOrderBo queryOrder(TrainGdxOrderQryBo orderQryBo) {
        TrainGdxOrderBo trainGdxOrderBo = trainGdxOrderRepository.queryOrder(orderQryBo);
        List<TrainGdxOrderItemBo> trainGdxOrderItemBos = trainGdxOrderItemRepository.queryByOrderId(orderQryBo.getOrderId());
        trainGdxOrderBo.setOrderItemList(trainGdxOrderItemBos);
        return trainGdxOrderBo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createOrder(TrainGdxOrderBo trainGdxOrderBo) {
        Long orderId = trainGdxOrderRepository.createOrder(trainGdxOrderBo);
        for (TrainGdxOrderItemBo trainGdxOrderItemBo : trainGdxOrderBo.getOrderItemList()) {
            trainGdxOrderItemBo.setOrderId(orderId);
            trainGdxOrderItemRepository.createOrderItem(trainGdxOrderItemBo);
        }
        return orderId;
    }

    @Override
    public void updateOrder(TrainGdxOrderBo trainGdxOrderBo) {
        trainGdxOrderRepository.updateOrder(trainGdxOrderBo);
    }
}
