package com.tydic.train.model.gdx.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.gdx.task.TrainGdxProcessInstModel;
import com.tydic.train.repository.gdx.TrainGdxProcessInstRepository;
import com.tydic.train.repository.gdx.TrainGdxTaskInstRepository;
import com.tydic.train.service.gdx.task.bo.TrainGdxProcessInstBo;
import com.tydic.train.service.gdx.task.bo.TrainGdxTaskInstBo;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/29 17:22
 */
@Service
@RequiredArgsConstructor
public class TrainGdxProcessInstModelImpl implements TrainGdxProcessInstModel {

    private final TrainGdxProcessInstRepository trainGdxProcessInstRepository;

    private final TrainGdxTaskInstRepository trainGdxTaskInstRepository;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createTask(TrainGdxProcessInstBo processInstBo) {

        trainGdxProcessInstRepository.createOrUpdate(processInstBo);
        trainGdxTaskInstRepository.insertOrUpdateBatch(processInstBo.getProcInstId(), processInstBo.getTaskInstList());
    }


    @Override
    public TrainGdxProcessInstBo queryTask(String taskId) {
        TrainGdxTaskInstBo trainGdxTaskInstBo = trainGdxTaskInstRepository.queryByTaskId(taskId);
        if (trainGdxTaskInstBo == null) {
            return null;
        }
        TrainGdxProcessInstBo trainGdxProcessInstBo = trainGdxProcessInstRepository.queryByFlowId(trainGdxTaskInstBo.getProcInstId());

        List<TrainGdxTaskInstBo> trainGdxTaskInstBos = trainGdxTaskInstRepository.queryByFlowId(trainGdxTaskInstBo.getProcInstId());

        trainGdxProcessInstBo.setTaskInstList(trainGdxTaskInstBos);
        return trainGdxProcessInstBo;
    }


    @Override
    public void updateFlowTask(TrainGdxProcessInstBo processInstBo) {
        trainGdxProcessInstRepository.createOrUpdate(processInstBo);
        if (CollectionUtil.isNotEmpty(processInstBo.getTaskInstList())) {
            for (TrainGdxTaskInstBo trainGdxTaskInstBo : processInstBo.getTaskInstList()) {
                trainGdxTaskInstRepository.update(trainGdxTaskInstBo);
            }
        }
    }

    @Override
    public void updateTask(List<TrainGdxTaskInstBo> taskInstList) {
        if (CollectionUtil.isNotEmpty(taskInstList)) {
            for (TrainGdxTaskInstBo trainGdxTaskInstBo : taskInstList) {
                trainGdxTaskInstRepository.update(trainGdxTaskInstBo);
            }
        }
    }


    @Override
    public TrainGdxProcessInstBo queryFlowTask(String flowInstId, String objId) {
        if (StrUtil.isEmpty(flowInstId) && StrUtil.isEmpty(objId)) {
            throw new ZTBusinessException("参数错误");
        }
        TrainGdxProcessInstBo trainGdxProcessInstBo;
        if (StrUtil.isNotBlank(objId)) {
            trainGdxProcessInstBo = trainGdxProcessInstRepository.queryByObjId(objId);
        } else {
            trainGdxProcessInstBo = trainGdxProcessInstRepository.queryByFlowId(flowInstId);
        }
        if (trainGdxProcessInstBo == null) {
            throw new ZTBusinessException("流程不存在");
        }
        List<TrainGdxTaskInstBo> trainGdxTaskInstBos = trainGdxTaskInstRepository.queryByFlowId(trainGdxProcessInstBo.getProcInstId());
        trainGdxProcessInstBo.setTaskInstList(trainGdxTaskInstBos);
        return trainGdxProcessInstBo;
    }

    @Override
    public void deleteBatchTask(List<String> taskIds) {
        trainGdxTaskInstRepository.deleteBatchTask(taskIds);
    }
}
