package com.tydic.train.model.lyandyyf;

import com.tydic.train.service.ly.ship.bo.*;

import java.util.List;

/**
 * 类名：TrainYyfShipOrderItemModelImpl
 * 标题：
 * 说明：
 * 时间：2023/8/31 10:29
 *
 * @author yangyf
 **/
public interface TrainYyfShipOrderModel {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO queryTrainShipOrderSingle(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderListRspBO queryTrainShipOrderList(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO addTrainShipOrder(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderListRspBO addListTrainShipOrder(List<TrainYyfShipOrderReqBO> TrainYyfShipOrderReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO updateTrainShipOrder(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO saveTrainShipOrder(TrainYyfShipOrderReqBO reqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    TrainYyfShipOrderRspBO deleteTrainShipOrder(TrainYyfShipOrderReqBO reqBO);

}
