package com.tydic.train.model.lyandyyf.impl;

import com.tydic.train.model.lyandyyf.TrainYyfShipOrderItemModel;
import com.tydic.train.repository.TrainYyfShipOrderItemRepository;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemListRspBO;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemReqBO;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemRspBO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 类名：TrainYyfShipOrderItemModelImpl
 * 标题：
 * 说明：
 * 时间：2023/8/31 10:30
 *
 * @author yangyf
 **/

@Service
public class TrainYyfShipOrderItemModelImpl implements TrainYyfShipOrderItemModel {

    private TrainYyfShipOrderItemRepository trainYyfShipOrderItemRepository;
    
    /**
     * 描述:查询信息（单个）
     *
     * @param TrainYyfShipOrderItemReqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO queryTrainShipOrderItemSingle(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemRepository.queryTrainShipOrderItemSingle(reqBO);
    }

    /**
     * 描述:查询信息列表
     *
     * @param TrainYyfShipOrderItemReqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemListRspBO queryTrainShipOrderItemList(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemRepository.queryTrainShipOrderItemList(reqBO);
    }

    /**
     * 描述:新增信息
     *
     * @param TrainYyfShipOrderItemReqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO addTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemRepository.addTrainShipOrderItem(reqBO);
    }

    /**
     * 描述:新增多条信息
     *
     * @param TrainYyfShipOrderItemReqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemListRspBO addListTrainShipOrderItem(List<TrainYyfShipOrderItemReqBO> reqBO) {
        return trainYyfShipOrderItemRepository.addListTrainShipOrderItem(reqBO);
    }

    /**
     * 描述:修改信息
     *
     * @param TrainYyfShipOrderItemReqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO updateTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemRepository.updateTrainShipOrderItem(reqBO);
    }

    /**
     * 描述:保存信息
     *
     * @param TrainYyfShipOrderItemReqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO saveTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemRepository.saveTrainShipOrderItem(reqBO);
    }

    /**
     * 描述:删除信息
     *
     * @param TrainYyfShipOrderItemReqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO deleteTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemRepository.deleteTrainShipOrderItem(reqBO);
    }
}
