package com.tydic.train.model.lyandyyf.impl;

import com.tydic.train.model.lyandyyf.TrainYyfShipOrderModel;
import com.tydic.train.repository.TrainYyfShipOrderRepository;
import com.tydic.train.service.ly.ship.bo.*;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 类名：TrainYyfShipOrderItemModelImpl
 * 标题：
 * 说明：
 * 时间：2023/8/31 10:30
 *
 * @author yangyf
 **/

@Service
public class TrainYyfShipOrderModelImpl implements TrainYyfShipOrderModel {

    private TrainYyfShipOrderRepository trainYyfShipOrderRepository;

    /**
     * 描述:查询信息（单个）
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO queryTrainShipOrderSingle(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderRepository.queryTrainShipOrderSingle(reqBO);
    }

    /**
     * 描述:查询信息列表
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderListRspBO queryTrainShipOrderList(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderRepository.queryTrainShipOrderList(reqBO);
    }

    /**
     * 描述:新增信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO addTrainShipOrder(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderRepository.addTrainShipOrder(reqBO);
    }

    /**
     * 描述:新增多条信息
     *
     * @param TrainYyfShipOrderReqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderListRspBO addListTrainShipOrder(List<TrainYyfShipOrderReqBO> reqBO) {
        return trainYyfShipOrderRepository.addListTrainShipOrder(reqBO);
    }

    /**
     * 描述:修改信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO updateTrainShipOrder(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderRepository.updateTrainShipOrder(reqBO);
    }

    /**
     * 描述:保存信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO saveTrainShipOrder(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderRepository.saveTrainShipOrder(reqBO);
    }

    /**
     * 描述:删除信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO deleteTrainShipOrder(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderRepository.deleteTrainShipOrder(reqBO);
    }
}
