package com.tydic.train.model.mc.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.train.model.mc.task.TrainMcTaskDo;
import com.tydic.train.model.mc.task.TrainMcTaskModel;
import com.tydic.train.model.mc.task.qrybo.TrainMcProcessInstQryBo;
import com.tydic.train.model.mc.task.qrybo.TrainMcTaskInstQryBo;
import com.tydic.train.model.mc.task.sub.TrainMcProcessInst;
import com.tydic.train.model.mc.task.sub.TrainMcProcessInstList;
import com.tydic.train.model.mc.task.sub.TrainMcTaskInst;
import com.tydic.train.model.mc.task.sub.TrainMcTaskInstList;
import com.tydic.train.repository.mc.TrainMcTaskRepository;
import com.tydic.train.service.course.constants.BaseRspConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：TrainMcTaskModelImpl
 * 说明：
 * 时间：2023/08/30 17:02
 *
 * @author 马冲
 **/
@Service
public class TrainMcTaskModelImpl implements TrainMcTaskModel {

    @Autowired
    private TrainMcTaskRepository trainMcTaskRepository;

    @Override
    public TrainMcTaskDo dealTask(TrainMcTaskDo taskDo) {

        //处理任务
        if(!CollectionUtils.isEmpty(taskDo.getCompleteTaskInstList())){
            for(TrainMcTaskInst taskInst : taskDo.getCompleteTaskInstList()){
                TrainMcTaskInstQryBo taskInstQryBo = new TrainMcTaskInstQryBo();
                taskInstQryBo.setTaskId(taskInst.getTaskId());
                TrainMcTaskInstList taskInstList = trainMcTaskRepository.qryTaskInstList(taskInstQryBo);
                //不存在，报错
                if (ObjectUtil.isEmpty(taskInstList.getTaskInstList())) {
                    throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "任务实例id(" + taskInst.getTaskId() + ")不存在");
                }

                TrainMcTaskInst updateTaskInst = new TrainMcTaskInst();
                updateTaskInst.setTaskId(taskInst.getTaskId());
                trainMcTaskRepository.updateToFinished(updateTaskInst);
            }
        }
        //新任务
        if(!CollectionUtils.isEmpty(taskDo.getTaskInstList())){

            TrainMcTaskInstList trainMcTaskInstList = new TrainMcTaskInstList();
            List<TrainMcTaskInst> taskInstList = new ArrayList<>();
            trainMcTaskInstList.setTaskInstList(taskInstList);
            for(TrainMcTaskInst nextTaskInst : taskDo.getTaskInstList()){
                TrainMcProcessInstQryBo qryInst = new TrainMcProcessInstQryBo();
                qryInst.setProcInstId(taskDo.getProcInstId());
                TrainMcProcessInstList processInstList = trainMcTaskRepository.qryProcessInstList(qryInst);
                if(CollectionUtils.isEmpty(processInstList.getProcessInstList())){

                    TrainMcProcessInst processInst = new TrainMcProcessInst();
                    processInst.setProcInstId(taskDo.getProcInstId());
                    processInst.setProcDefId(taskDo.getProcDefId());
                    processInst.setProcKey(taskDo.getProcKey());
                    processInst.setObjId(taskDo.getObjId());
                    processInst.setObjType(taskDo.getObjType());
                    processInst.setStepCode(taskDo.getStepCode());
                    processInst.setStepName(taskDo.getStepName());
                    processInst.setIsFinish(taskDo.getIsFinish());
                    processInst.setParentProcInstId(taskDo.getParentProcInstId());
                    processInst.setProcType(taskDo.getProcType());
                    trainMcTaskRepository.createProcessInst(processInst);
                }

                TrainMcTaskInst taskBo = new TrainMcTaskInst();
                taskBo.setTaskId(nextTaskInst.getTaskId());
                taskBo.setProcInstId(nextTaskInst.getProcInstId());
                taskBo.setStepCode(nextTaskInst.getStepCode());
                taskBo.setStepName(nextTaskInst.getStepName());
                taskBo.setStepStatus(nextTaskInst.getStepStatus());
                taskBo.setPendingUserId(nextTaskInst.getPendingUserId());
                taskBo.setPendingUserName(nextTaskInst.getPendingUserName());
                taskInstList.add(taskBo);

            }
            trainMcTaskRepository.insertTaskInstList(trainMcTaskInstList);
        }

        return taskDo;
    }

}
