package com.tydic.train.model.order;

import com.tydic.train.model.order.qrybo.TrainHWOrderChangeQryBO;
import com.tydic.train.model.order.qrybo.TrainHWOrderCreateQryBo;
import com.tydic.train.model.order.sub.TrainHWOrderCreateSubBo;
import com.tydic.train.model.order.sub.TrainHWShipCreateQryBO;
import com.tydic.train.model.order.sub.TrainHWShipCreateSubBO;
import com.tydic.train.service.order.bo.TrainHWInvoiceCreateReqBO;
import com.tydic.train.service.order.bo.TrainHWInvoiceCreateRspBO;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc 订单
 * @ClassName TrainHWOrderModel
 * @date 2023/8/28 17:05
 */
public interface TrainHWOrderModel {
  TrainHWOrderCreateSubBo createOrder(TrainHWOrderCreateQryBo qryBo);

  /**
   * 订单查询
   * @param orderId
   * @return
   */
  TrainHWOrderCreateDo qryOrder(Long orderId);


  /**
   * 更新订单状态为已支付
   * @param qryBO
   * @return
   */
  TrainHWOrderCreateDo updateOrderStatus(TrainHWOrderChangeQryBO qryBO);
  /**
   * 创建发货单
   * @param qryBO
   * @return
   */
  TrainHWShipCreateSubBO createShipOrder(TrainHWShipCreateQryBO qryBO);

}
