package com.tydic.train.model.order;

import com.tydic.train.model.order.qrybo.TrainHWOrderChangeQryBO;
import com.tydic.train.service.order.TrainHWOrderStatusChangeService;
import com.tydic.train.service.order.bo.TrainHWOrderStatusChangeReqBO;
import com.tydic.train.service.order.bo.TrainHWOrderStatusChangeRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWOrderStatusChangeServiceImpl
 * @ClassName TrainHWOrderStatusChangeServiceImpl
 * @date 2023/8/31 14:24
 */
@HTServiceImpl
public class TrainHWOrderStatusChangeServiceImpl implements TrainHWOrderStatusChangeService {
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;
    @Override
    public TrainHWOrderStatusChangeRspBO changeStatus(TrainHWOrderStatusChangeReqBO reqBO) {
        TrainHWOrderChangeQryBO qryBO = new TrainHWOrderChangeQryBO();
        qryBO.setOrderId(reqBO.getOrderId());
        qryBO.setOrderStatus(reqBO.getOrderStatus());
        trainHWOrderModel.updateOrderStatus(qryBO);
        return new TrainHWOrderStatusChangeRspBO();
    }
}
