package com.tydic.train.model.order;

import com.tydic.train.service.course.bo.RspBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class TrainYyfOrderDo extends RspBo {
    private static final long serialVersionUID = -5293452501806109806L;

    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 订单名称
     */
    private String orderName;
    /**
     * 订单总金额
     */
    private BigDecimal orderMoney;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建时间
     */
    private Date createTime;

    private Date createTimeStart;
    private Date createTimeEnd;

    /**
     * 删除标记 ;0未删除  1已删除
     */
    private Integer delFlag;
    /**
     * 订单状态;订单状态:
     * 1：待确认
     * 2：待支付
     * 3：待发货
     * 4：已发货
     */
    private Integer orderStatus;
    /**
     * 订单信息
     */
    private List<TrainYyfOrderItemDo> itemList;

}
