package com.tydic.train.model.order;

import com.tydic.train.model.order.sub.TrainZyyOrderItemBO;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：TrainZyyOrderDo
 * 说明：周钰焱订单Do
 * 时间：2023/8/28 17:38
 *
 * @author 周钰焱
 */
@Data
public class TrainZyyOrderDo implements Serializable {
    private static final long serialVersionUID = -6370775178244565034L;

    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 订单名称
     */
    private String orderName;
    /**
     * 订单总金额
     */
    private BigDecimal orderMoney;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 删除标记 ;0未删除  1已删除
     */
    private Integer delFlag;
    /**
     * 订单明细集合
     */
    List<TrainZyyOrderItemBO> orderItemBOList;
}
