package com.tydic.train.model.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.constants.TrainHWRspConstant;
import com.tydic.train.model.order.TrainHWOrderCreateDo;
import com.tydic.train.model.order.TrainHWOrderModel;
import com.tydic.train.model.order.qrybo.TrainHWOrderChangeQryBO;
import com.tydic.train.model.workflow.TrainHWProcessTaskDo;
import com.tydic.train.model.workflow.TrainHWProcessTaskModel;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessTaskQryBo;
import com.tydic.train.service.course.bo.RspBo;
import com.tydic.train.service.course.exception.BaseBusinessException;
import com.tydic.train.service.order.TrainHWConfirmService;
import com.tydic.train.service.order.bo.TrainHWConfirmReqBO;
import com.tydic.train.service.order.bo.TrainHWConfirmRspBO;
import com.tydic.train.service.pay.bo.TrainHWProcessTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWConfirmServiceImpl
 * @ClassName TrainHWConfirmServiceImpl
 * @date 2023/8/30 16:50
 */
@HTServiceImpl
public class TrainHWConfirmServiceImpl implements TrainHWConfirmService {
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;
    @Autowired
    private TrainHWProcessTaskModel trainHWProcessTaskModel;

    @Override
    public TrainHWConfirmRspBO supConfirm(TrainHWConfirmReqBO reqBO) {
        validate(reqBO);
        //校验状态
        validateOrderStatus(reqBO.getOrderId());
        //校验当前业务环节
        TrainHWProcessTaskBo taskBo = validateProcess(reqBO);
        //更新订单支付状态 只写通过
        if (TrainHWRspConstant.AUDIT_RESULT_FLAG.pass.equals(reqBO.getAuditResult())) {
            dealOrderStatusChange(reqBO);
        }
        TrainHWConfirmRspBO rspBO = new TrainHWConfirmRspBO();
        rspBO.setTaskId(taskBo.getTaskId());
        rspBO.setRespCode(TrainHWRspConstant.SUC_CODE);
        return rspBO;
    }

    private void validateOrderStatus(Long orderId) {
        TrainHWOrderCreateDo createDo = trainHWOrderModel.qryOrder(orderId);
        if (ObjectUtil.isEmpty(createDo)) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "未查询到订单信息");
        }
        if (!TrainHWRspConstant.ORDER_STATUS.TO_BE_CONFIRMED.equals(createDo.getOrderStatus())) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "订单不处于待确认状态->" + createDo.getOrderStatus());
        }
    }

    /**
     * 订单状态变更
     *
     * @param reqBO
     */
    private void dealOrderStatusChange(TrainHWConfirmReqBO reqBO) {
        TrainHWOrderChangeQryBO orderChangeQryBO = new TrainHWOrderChangeQryBO();
        orderChangeQryBO.setOrderStatus(TrainHWRspConstant.ORDER_STATUS.TO_BE_PAID);
        orderChangeQryBO.setOrderId(reqBO.getOrderId());
        trainHWOrderModel.updateOrderStatus(orderChangeQryBO);
    }

    /**
     * 流程实例校验
     *
     * @param reqBO
     * @return
     */
    private TrainHWProcessTaskBo validateProcess(TrainHWConfirmReqBO reqBO) {
        TrainHWProcessTaskQryBo taskQryBo = new TrainHWProcessTaskQryBo();
        taskQryBo.setObjId(reqBO.getOrderId().toString());
        TrainHWProcessTaskDo taskDo = trainHWProcessTaskModel.qryProcees(taskQryBo);
        if (TrainHWRspConstant.SUCCESS_CODE.equals(taskDo.getCode())) {
            if (CollectionUtils.isEmpty(taskDo.getTaskBoList()) || taskDo.getTaskBoList().size() > 1) {
                throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "流程实例不存在 或者 存在多条激活的实例");
            }
            return taskDo.getTaskBoList().get(0);
        }
        throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "流程任务实例校验失败");
    }

    private void validate(TrainHWConfirmReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getOrderId())) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "参数 orderId 不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getAuditResult())) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "参数 auditResult 不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getUserId())) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "参数 userId 不能为空");
        }
    }
}
