package com.tydic.train.model.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.constants.TrainHWRspConstant;
import com.tydic.train.model.order.TrainHWOrderCreateDo;
import com.tydic.train.model.order.TrainHWOrderModel;
import com.tydic.train.model.order.qrybo.TrainHWOrderChangeQryBO;
import com.tydic.train.model.order.sub.TrainHWShipCreateQryBO;
import com.tydic.train.model.order.sub.TrainHWShipCreateSubBO;
import com.tydic.train.model.workflow.TrainHWProcessTaskDo;
import com.tydic.train.model.workflow.TrainHWProcessTaskModel;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessTaskQryBo;
import com.tydic.train.service.course.exception.BaseBusinessException;
import com.tydic.train.service.order.TrainHWInvoiceCreateService;
import com.tydic.train.service.order.bo.TrainHWInvoiceCreateReqBO;
import com.tydic.train.service.order.bo.TrainHWInvoiceCreateRspBO;
import com.tydic.train.service.pay.bo.TrainHWProcessTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWInvoiceCreateServiceImpl
 * @ClassName TrainHWInvoiceCreateServiceImpl
 * @date 2023/8/30 16:59
 */
@HTServiceImpl
public class TrainHWInvoiceCreateServiceImpl implements TrainHWInvoiceCreateService {
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;
    @Autowired
    private TrainHWProcessTaskModel trainHWProcessTaskModel;


    @Override
    public TrainHWInvoiceCreateRspBO createInvoice(TrainHWInvoiceCreateReqBO reqBO) {
        validateOrderStatus(reqBO.getOrderId());
        validate(reqBO);
        //校验任务实例
        TrainHWProcessTaskBo taskBo = validateProcess(reqBO);
        //更新订单状态
        dealOrderStatusChange(reqBO);
        //创建发货单
        Long shipOrderId = dealCreateShipOrder(reqBO);
        TrainHWInvoiceCreateRspBO rspBO = new TrainHWInvoiceCreateRspBO();
        rspBO.setTaskId(taskBo.getTaskId());
        rspBO.setShipOrderId(shipOrderId);
        rspBO.setRespCode(TrainHWRspConstant.SUC_CODE);
        return rspBO;
    }

    private void validateOrderStatus(Long orderId) {
        TrainHWOrderCreateDo createDo = trainHWOrderModel.qryOrder(orderId);
        if (ObjectUtil.isEmpty(createDo)) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "未查询到订单信息");
        }
        if (!TrainHWRspConstant.ORDER_STATUS.TO_BE_SHIPPED.equals(createDo.getOrderStatus())) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE, "订单不处于待发货状态->" + createDo.getOrderStatus());
        }
    }

    /**
     * 发货单创建
     *
     * @param reqBO
     */
    private Long dealCreateShipOrder(TrainHWInvoiceCreateReqBO reqBO) {
        TrainHWShipCreateQryBO shipCreateQryBO = JSONObject.parseObject(JSON.toJSONString(reqBO), TrainHWShipCreateQryBO.class);
        TrainHWShipCreateSubBO shipCreateSubBO = trainHWOrderModel.createShipOrder(shipCreateQryBO);
        if (!"0".equals(shipCreateSubBO.getCode())) {
            throw new ZTBusinessException(shipCreateSubBO.getMessage());
        }
        return shipCreateSubBO.getShipOrderId();

    }

    /**
     * 订单状态变更
     *
     * @param reqBO
     */
    private void dealOrderStatusChange(TrainHWInvoiceCreateReqBO reqBO) {
        TrainHWOrderChangeQryBO orderChangeQryBO = new TrainHWOrderChangeQryBO();
        orderChangeQryBO.setOrderStatus(TrainHWRspConstant.ORDER_STATUS.SHIPPED);
        orderChangeQryBO.setOrderId(reqBO.getOrderId());
        trainHWOrderModel.updateOrderStatus(orderChangeQryBO);
    }

    /**
     * 流程实例校验
     *
     * @param reqBO
     * @return
     */
    private TrainHWProcessTaskBo validateProcess(TrainHWInvoiceCreateReqBO reqBO) {
        TrainHWProcessTaskQryBo taskQryBo = new TrainHWProcessTaskQryBo();
        taskQryBo.setObjId(reqBO.getOrderId().toString());
        TrainHWProcessTaskDo taskDo = trainHWProcessTaskModel.qryProcees(taskQryBo);
        if (TrainHWRspConstant.SUCCESS_CODE.equals(taskDo.getCode())) {
            if (CollectionUtils.isEmpty(taskDo.getTaskBoList()) || taskDo.getTaskBoList().size() > 1) {
                throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE,"流程实例不存在 或者 存在多条激活的实例");
            }
            return taskDo.getTaskBoList().get(0);
        }
        throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE,"流程任务实例校验失败");
    }

    private void validate(TrainHWInvoiceCreateReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getOrderId())) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE,"参数 orderId 不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getInvoiceDetailBOS())) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE,"参数 invoiceDetailBOS 不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getShipUserId())) {
            throw new BaseBusinessException(TrainHWRspConstant.FAIL_CODE,"参数 shipUserId 不能为空");
        }
    }
}
