package com.tydic.train.model.order.impl;

import com.tydic.train.model.order.TrainLYOrderModel;
import com.tydic.train.model.order.bo.TrainLYOrderRepositoryReqBO;
import com.tydic.train.model.order.bo.TrainLYOrderRepositoryRspBO;
import com.tydic.train.repository.TrainLYOrderRepository;
import com.tydic.train.service.order.bo.TrainLYCreateOrderReqBO;
import com.tydic.train.service.order.bo.TrainLYCreateOrderRspBO;
import com.tydic.train.service.order.bo.TrainLYUpdateOrderReqBO;
import org.springframework.stereotype.Service;

/**
 * 标题：TrainLYOrderModelImpl
 * 说明：
 * 时间： 2023-08-29 16:56
 * 作者 @author LY
 */
@Service
public class TrainLYOrderModelImpl implements TrainLYOrderModel {

    private TrainLYOrderRepository trainLYOrderRepository;

    public TrainLYOrderModelImpl(TrainLYOrderRepository trainLYOrderRepository) {
        this.trainLYOrderRepository = trainLYOrderRepository;
    }

    @Override
    public TrainLYOrderRepositoryRspBO createOrder(TrainLYCreateOrderReqBO reqBO) {
        return trainLYOrderRepository.createOrder(reqBO);
    }

    @Override
    public TrainLYOrderRepositoryRspBO qryOrder(TrainLYOrderRepositoryReqBO reqBO) {
        return trainLYOrderRepository.qryOrder(reqBO);
    }

    @Override
    public TrainLYCreateOrderRspBO updateOrderStatus(TrainLYUpdateOrderReqBO reqBO) {
        return trainLYOrderRepository.updateOrderStatus(reqBO);
    }
}
