package com.tydic.train.model.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.train.model.lj.order.TrainLjDealTaskDO;
import com.tydic.train.model.lj.order.TrainLjProcessInstBO;
import com.tydic.train.model.lj.order.TrainLjTaskInstBO;
import com.tydic.train.model.order.TrainLxjDealTaskModel;
import com.tydic.train.repository.lj.TrainLjProcessInstRepository;
import com.tydic.train.repository.lj.TrainLjTaskInstRepository;
import com.tydic.train.service.course.bo.TrainLxjDealTaskRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：
 * 说明：
 * 时间：2023/8/30
 *
 * @author：lantian
 **/
@Service
public class TrainLxjDealTaskModelImpl implements TrainLxjDealTaskModel {
    @Autowired
    private TrainLjTaskInstRepository trainLjTaskInstRepository;
    @Autowired
    private TrainLjProcessInstRepository trainLjProcessInstRepository;

    /**
     * 处理待办
     *
     * @param reqBO
     * @return
     */
    @Override
    public TrainLxjDealTaskRspBO dealTaskInfo(TrainLjDealTaskDO reqBO) {
        if (!CollectionUtil.isEmpty(reqBO.getCompletedTaskList())){
            //完成已办
            reqBO.setDel(0);
            trainLjTaskInstRepository.dealCompletedTaskInfo(reqBO);
            if ("true".equals(reqBO.getLinkJudge())){
                //如果流程完成当前环节，查询当前流程实例，当前环节的，干掉其他已办
                TrainLjTaskInstBO instBO = new TrainLjTaskInstBO();
                instBO.setStepCode(reqBO.getCompletedTaskList().get(0).getStepCode());
                instBO.setStepStatus(0);
                instBO.setProcInstId(reqBO.getCompletedTaskList().get(0).getProcInstId());
                TrainLjDealTaskDO dealTaskDO = trainLjTaskInstRepository.getTaskInfo(instBO);
                dealTaskDO.setDel(1);
                dealTaskDO.setCompletedTaskList(dealTaskDO.getTaskInstList());
                trainLjTaskInstRepository.dealCompletedTaskInfo(dealTaskDO);
            }
        }
        if (!CollectionUtil.isEmpty(reqBO.getTaskInstList())){
            //保存待办
            trainLjTaskInstRepository.saveTaskInfo(reqBO.getTaskInstList());
        }
        TrainLxjDealTaskRspBO rspBO = new TrainLxjDealTaskRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        if (StringUtils.isBlank(reqBO.getProcInstId())){
            return rspBO;
        }
        TrainLjProcessInstBO processInstBO = new TrainLjProcessInstBO();
        processInstBO.setProcInstId(reqBO.getProcInstId());
        TrainLjProcessInstBO  get = trainLjProcessInstRepository.getProcessInfo(processInstBO);
        if (get ==null){
            BeanUtils.copyProperties(reqBO,processInstBO);
            trainLjProcessInstRepository.getProcessInfo(processInstBO);
        }else {
            BeanUtils.copyProperties(reqBO,processInstBO);
            trainLjProcessInstRepository.updateProcessInfo(processInstBO);
        }


        return rspBO;
    }
}
