package com.tydic.train.model.order.impl;

import com.tydic.train.model.order.TrainLxjOrderModel;
import com.tydic.train.model.order.bo.TrainLxjOrderItemBO;
import com.tydic.train.model.order.bo.TrainLxjOrderRepositoryReqBO;
import com.tydic.train.model.order.bo.TrainLxjOrderRepositoryRspBO;

import com.tydic.train.repository.TrainLxjOrderRepository;

import com.tydic.train.utils.OrderGenerateIdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：
 * 说明：
 * 时间：2023/8/28
 *
 * @author：lantian
 **/
@Service
public class TrainLxjOrderModelImpl implements TrainLxjOrderModel {
    @Autowired
    private TrainLxjOrderRepository trainLxjOrderRepository;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    /**
     * 创建订单
     *
     * @param reqBO
     * @return
     */
    @Override
    public TrainLxjOrderRepositoryRspBO createOrder(TrainLxjOrderRepositoryReqBO reqBO) {
        reqBO.setOrderId(idUtil.nextId());
        for (TrainLxjOrderItemBO itemBO :reqBO.getItemInfos()) {
            itemBO.setOrderId(reqBO.getOrderId());
            itemBO.setItemId(idUtil.nextId());
        }
        return trainLxjOrderRepository.createOrder(reqBO);
    }

    /**
     * 查询订单
     *
     * @param reqBO
     * @return
     */
    @Override
    public TrainLxjOrderRepositoryRspBO qryOrder(TrainLxjOrderRepositoryReqBO reqBO) {
        return trainLxjOrderRepository.qryOrder(reqBO);
    }

    /**
     * 修改订单
     *
     * @param reqBO
     * @return
     */
    @Override
    public TrainLxjOrderRepositoryRspBO updateOrder(TrainLxjOrderRepositoryReqBO reqBO) {
        return trainLxjOrderRepository.updateOrder(reqBO);
    }
}
