package com.tydic.train.model.order.impl;

import com.tydic.train.model.order.TrainYyfOrderModel;
import com.tydic.train.model.order.TrainYyfOrderDo;
import com.tydic.train.repository.TrainYyfOrderRepository;
import com.tydic.train.service.ly.order.bo.TrainYyfShipGoodsReqBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class TrainYyfOrderModelImpl implements TrainYyfOrderModel {

    @Autowired
    private TrainYyfOrderRepository trainYyfOrderRepository;

    /**
     * 创建订单
     *
     * @param insertOrderDO
     * @return
     */
    @Override
    public Long insertOrder(TrainYyfOrderDo insertOrderDO) {
        return trainYyfOrderRepository.insertOrder(insertOrderDO);
    }


    /**
     * 订单查询
     *
     * @param qryDO
     * @return
     */
    @Override
    public TrainYyfOrderDo qryOrder(TrainYyfOrderDo qryDO) {
        return trainYyfOrderRepository.qryOrderDetail(qryDO);
    }

    /**
     * 订单修改
     *
     * @param updateDO
     * @return
     */
    @Override
    public void updateOrder(TrainYyfOrderDo updateDO) {
        trainYyfOrderRepository.updateOrder(updateDO);
    }

    /**
     * 描述:发货
     *
     * @param shipGoodsReqBO
     */
    @Override
    public TrainYyfOrderDo shipGoods(TrainYyfShipGoodsReqBO shipGoodsReqBO) {
        return trainYyfOrderRepository.shipGoods(shipGoodsReqBO);
    }
}
