package com.tydic.train.model.shiporder;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 描述：发货单表
 *
 * @author Lihulin
 * @date 2023-08-29 17:34
 **/
@Data
public class TrainLHLShipOrderDO implements Serializable {
    private static final long serialVersionUID = -5722337016903228400L;

    /**
     * 发货单id
     */
    private Long shipOrderId;
    /**
     * 发货单编号
     */
    private String shipOrderNo;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 发货人ID
     */
    private Long shipUserId;
    /**
     * 发货人名称
     */
    private String shipUserName;
    /**
     * 发货时间
     */
    private Date shipTime;
    /**
     * 删除标记 ;0未删除  1已删除
     */
    private Integer delFlag;
    /**
     * 发货单明细
     */
    private List<TrainLHLShipOrderItemDO> itemList;

}
