package com.tydic.train.model.shiporder;

import lombok.Data;

import java.io.Serializable;

/**
 * 描述：发货单明细表
 *
 * @author Lihulin
 * @date 2023-08-29 17:34
 **/
@Data
public class TrainLHLShipOrderItemDO implements Serializable {
    private static final long serialVersionUID = 3529297336810422657L;

    /**
     * 发货单明细id
     */
    private Long shipItemId;
    /**
     * 发货单id
     */
    private Long shipOrderId;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 订单明细id
     */
    private Long itemId;
    /**
     * 商品ID
     */
    private Long goodsId;
    /**
     * 发货数量
     */
    private Integer shipCount;
    /**
     * 购买数量
     */
    private Integer count;
    /**
     * 删除标记 ;0未删除  1已删除
     */
    private Integer delFlag;


}
