package com.tydic.train.model.task;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 描述：流程实例表
 *
 * @author Lihulin
 * @date 2023-08-29 17:34
 **/
@Data
public class TrainLHLProcessInstDO implements Serializable {
    private static final long serialVersionUID = 7887487457432927480L;

    /**
     * 流程实例id
     */
    private String procInstId;
    /**
     * 流程实例id列表
     */
    private List<String> procInstIds;
    /**
     * 流程定义id
     */
    private String procDefId;
    /**
     * 流程key
     */
    private String procKey;
    /**
     * 业务单据id
     */
    private String objId;
    /**
     * 业务单据类型:
     * 1:订单
     */
    private Integer objType;
    /**
     * 当前环节编码
     */
    private String stepCode;
    /**
     * 当前环节名称
     */
    private String stepName;
    /**
     * 流程是否结束:
     * 0：未结束
     * 1：已结束
     */
    private Integer isFinish;
    /**
     * 删除标记 ;0未删除  1已删除
     */
    private Integer delFlag;
    /**
     * 排序
     */
    private String orderBy;

}
