package com.tydic.train.model.task;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 描述：任务实例表
 *
 * @author Lihulin
 * @date 2023-08-29 17:34
 **/
@Data
public class TrainLHLTaskInstDO implements Serializable {
    private static final long serialVersionUID = 2102223577878263437L;

    /**
     * 流程实例id
     */
    private String procInstId;
    /**
     * 流程实例id列表
     */
    private List<String> procInstIds;
    /**
     * 任务id
     */
    private String taskId;
    /**
     * 当前环节编码
     */
    private String stepCode;
    /**
     * 当前环节名称
     */
    private String stepName;
    /**
     * 环节状态:
     * 0：待处理
     * 1：已处理
     */
    private Integer stepStatus;
    /**
     * 待处理人id
     */
    private String pendingUserId;
    /**
     * 待处理人名称
     */
    private String pendingUserName;
    /**
     * 处理时间
     */
    private Date dealTime;
    /**
     * 删除标记 ;0未删除  1已删除
     */
    private Integer delFlag;

    /**
     * 父流程实例id
     */
    private String parentProcInstId;
    /**
     * 流程类型
     * BUSINESS:业务流
     * APPROVAL：审批流
     */
    private String procType;

    /**
     * 排序
     */
    private String orderBy;

}
