package com.tydic.train.model.tfquoc;

import com.tydic.train.model.tfquoc.qrybo.TrainTfqOrderQryBO;
import com.tydic.train.model.tfquoc.qrybo.TrainTfqTaskInstQryBO;
import com.tydic.train.model.tfquoc.sub.*;

import java.util.List;

/**
 * 标题 TrainTfqOrderModel
 * 说明 订单
 * 时间 2023/8/28 15:58
 *
 * @author 唐富强
 */
public interface TrainTfqOrderModel {

    /**
     * 订单详情查询
     * @param qryBO
     * @return
     */
    TrainTfqOrderDetailsDO getOrderDetails(TrainTfqOrderQryBO qryBO);


    /**
     * 创建订单
     * @param createOrderDO
     */
    TrainTfqCreateOrderDO createOrder(TrainTfqCreateOrderDO createOrderDO);

    /**
     * 更新订单
     * @param orderDO
     */
     void update(TrainTfqOrderDO orderDO);

    /**
     * 创建发货单
     * @param orderDO
     */
    void createShipOrder(TrainTfqCreateShipOrderDO orderDO);

    /**
     * 流程实例批量新增
     * @param list
     */
    void insertBatchProcessIns(List<TrainTfqProcessInstDO> list);

    /**
     * 批量更新流程实例
     * @param list
     */
    void updateBatchProcessIns(List<TrainTfqProcessInstDO> list);

    TrainTfqProcessInstDO getProcessInst(TrainTfqProcessInstDO processInstDO);

    void insertBatchTaskInst(List<TrainTfqTaskInstDO> list);

    void updateBatchByTaskId(TrainTfqTaskInstQryBO bo);

    List<TrainTfqTaskInstDO> getTaskList(TrainTfqTaskInstDO taskInstDO);
}
