package com.tydic.train.model.workflow.impl;

import com.tydic.train.model.workflow.TrainHWProcessTaskDo;
import com.tydic.train.model.workflow.TrainHWProcessTaskModel;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessProcInstQryBO;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessTaskQryBo;
import com.tydic.train.model.workflow.qryBo.TrainHWTaskQryBO;
import com.tydic.train.model.workflow.qryBo.TrainHWTaskUpdateQryBO;
import com.tydic.train.model.workflow.subBo.TrainHWProcessProcInstSubBO;
import com.tydic.train.model.workflow.subBo.TrainHWProcessTaskSubBO;
import com.tydic.train.repository.workflow.TrainHWProcessTaskRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWProcessTaskModelImpl
 * @ClassName TrainHWProcessTaskModelImpl
 * @date 2023/8/30 15:02
 */
@Service
public class TrainHWProcessTaskModelImpl implements TrainHWProcessTaskModel {
    @Autowired
    private TrainHWProcessTaskRepository trainHWProcessTaskRepository;

    @Override
    public TrainHWProcessTaskDo qryProcees(TrainHWProcessTaskQryBo qryBo) {
        return trainHWProcessTaskRepository.qryProcees(qryBo);
    }

    @Override
    public TrainHWProcessProcInstSubBO addProcInst(TrainHWProcessProcInstQryBO qryBo) {
        return trainHWProcessTaskRepository.addProcInst(qryBo);
    }

    @Override
    public TrainHWProcessTaskDo addTaskBatch(TrainHWTaskQryBO qryBo) {
        return trainHWProcessTaskRepository.addTaskBatch(qryBo);
    }

    @Override
    public void updateBatchTask(TrainHWTaskUpdateQryBO qryBO) {
         trainHWProcessTaskRepository.updateBatchTask(qryBO);
    }

    @Override
    public void updateProc(TrainHWProcessProcInstQryBO qryBO) {
        trainHWProcessTaskRepository.updateProc(qryBO);
    }

    @Override
    public TrainHWProcessTaskSubBO qryTask(TrainHWProcessTaskQryBo qryBo) {
        return trainHWProcessTaskRepository.qryTask(qryBo);
    }

    @Override
    public void updateTask(TrainHWProcessTaskQryBo bo) {
        trainHWProcessTaskRepository.updateTask(bo);
    }
}
