package com.tydic.train.model.workflow.subBo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWProcessTaskSubBO
 * @ClassName TrainHWProcessTaskSubBO
 * @date 2023/8/31 20:27
 */
@Data
public class TrainHWProcessTaskSubBO implements Serializable {
    private static final long serialVersionUID = -4011501844262143425L;
    /**
     * 单据id
     */
    private String objId;
    /**
     * 待处理人id
     */
    private String pendingUserId;

    /**
     * 任务id
     */
    private String taskId;
    /**
     * 流程实例id
     */
    private String procInstId;
    /**
     * 当前环节编码
     */
    private String stepCode;
    /**
     * 当前环节名称
     */
    private String stepName;
    /**
     * 环节状态:
     0：待处理
     1：已处理
     */
    private Integer stepStatus;

    /**
     * 待处理人名称
     */
    private String pendingUserName;
    /**
     * 处理时间
     */
    private Date dealTime;
    private Date dealTimeStart;
    private Date dealTimeEnd;
    /**
     * 删除标记 ;0未删除  1已删除
     */
    private Integer delFlag;
    /**
     * 排序
     */
    private String orderBy;
}
