package com.tydic.train.model.zl;

import com.tydic.dyc.base.bo.RspBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: TrainZLGoodsRepository
 * @Description: TrainZLGoodsRepository
 * @author: zhoulu
 * @date: 2023年08月28日21:16:15
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class TrainZLOrderDO extends RspBo {
    private static final long serialVersionUID = 1L;
    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 订单名称
     */
    private String orderName;

    /**
     * 订单总金额
     */
    private BigDecimal orderMoney;

    /**
     * 创建人
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 订单详情
     */
    private TrainZLOrderItemDO itemDO;

    /**
     * 删除标识
     */
    private Integer delFlag;
    /**
     * 订单状态:1：待确认2：待支付3：待发货4：已发货
     */
    private Integer orderStatus;
}
