package com.tydic.train.model.zl;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName: TrainZLOrderItemDO
 * @Description: TrainZLOrderItemDO
 * @author: zhoulu
 * @date: 2023年08月28日21:16:15
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class TrainZLOrderItemDO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 明细ID
     */
    private Long itemId;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 商品价格
     */
    private BigDecimal goodsPrice;

    /**
     * 购买数量
     */
    private Integer count;

    /**
     * 总价小计
     */
    private BigDecimal totalMoney;

    /**
     * 删除标识
     */
    private Integer delFlag;
}
