package com.tydic.train.model.zl;

import java.util.List;

/**
 * 描述：流程实例表;流程实例表
 *
 * @author: zhoulu
 * @date: 2023-08-30 16:24:45
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface TrainZLProcessInstModel {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: trainProcessInstReqDO
     * @return: TrainZLProcessInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLProcessInstRspDO queryTrainZLProcessInstSingle(TrainZLProcessInstReqDO trainProcessInstReqDO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: trainProcessInstReqDO
     * @return: TrainZLProcessInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLProcessInstListRspDO queryTrainZLProcessInstList(TrainZLProcessInstReqDO trainProcessInstReqDO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: trainProcessInstReqDO
     * @return: TrainZLProcessInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLProcessInstRspDO addTrainZLProcessInst(TrainZLProcessInstReqDO trainProcessInstReqDO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: trainProcessInstReqDO
     * @return: TrainZLProcessInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLProcessInstListRspDO addListTrainZLProcessInst(List<TrainZLProcessInstReqDO> trainProcessInstReqDO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: trainProcessInstReqDO
     * @return: TrainZLProcessInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLProcessInstRspDO updateTrainZLProcessInst(TrainZLProcessInstReqDO trainProcessInstReqDO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: trainProcessInstReqDO
     * @return: TrainZLProcessInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLProcessInstRspDO saveTrainZLProcessInst(TrainZLProcessInstReqDO trainProcessInstReqDO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: trainProcessInstReqDO
     * @return: TrainZLProcessInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLProcessInstRspDO deleteTrainZLProcessInst(TrainZLProcessInstReqDO trainProcessInstReqDO);

}

