package com.tydic.train.model.zl;

import com.tydic.train.service.zl.bo.TrainZLShipOrderListRspBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderReqBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderRspBO;

import java.util.List;

/**
 * 描述：任务实例表
 *
 * @author: zhoulu
 * @date: 2023-08-30 16:24:45
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface TrainZLShipOrderModel {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: trainShipOrderReqBO
     * @return: TrainZLShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLShipOrderRspBO queryTrainZLShipOrderSingle(TrainZLShipOrderReqBO trainShipOrderReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: trainShipOrderReqBO
     * @return: TrainZLShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLShipOrderListRspBO queryTrainZLShipOrderList(TrainZLShipOrderReqBO trainShipOrderReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: trainShipOrderReqBO
     * @return: TrainZLShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLShipOrderRspBO addTrainZLShipOrder(TrainZLShipOrderReqBO trainShipOrderReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: trainShipOrderReqBO
     * @return: TrainZLShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLShipOrderListRspBO addListTrainZLShipOrder(List<TrainZLShipOrderReqBO> trainShipOrderReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: trainShipOrderReqBO
     * @return: TrainZLShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLShipOrderRspBO updateTrainZLShipOrder(TrainZLShipOrderReqBO trainShipOrderReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: trainShipOrderReqBO
     * @return: TrainZLShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLShipOrderRspBO saveTrainZLShipOrder(TrainZLShipOrderReqBO trainShipOrderReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: trainShipOrderReqBO
     * @return: TrainZLShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLShipOrderRspBO deleteTrainZLShipOrder(TrainZLShipOrderReqBO trainShipOrderReqBO);

}

