package com.tydic.train.repository;

import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.train.service.ly.task.bo.TrainLYProcessInstBO;
import com.tydic.train.service.ly.task.bo.TrainLYProcessInstListRspBO;
import com.tydic.train.service.ly.task.bo.TrainLYProcessInstReqBO;
import com.tydic.train.service.ly.task.bo.TrainLYProcessInstRspBO;

import java.util.List;

/**
 * 描述：流程实例表;流程实例表
 *
 * @author: liaoyang
 * @date: 2023-08-30 16:09:28
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface TrainLYProcessInstRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO queryTrainProcessInstSingle(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstListRspBO queryTrainProcessInstList(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO addTrainProcessInst(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstListRspBO addListTrainProcessInst(List<TrainLYProcessInstReqBO> reqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO updateTrainProcessInst(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO saveTrainProcessInst(TrainLYProcessInstReqBO reqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: TrainLYProcessInstReqBO
     * @return: TrainLYProcessInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYProcessInstRspBO deleteTrainProcessInst(TrainLYProcessInstReqBO reqBO);

}

