package com.tydic.train.repository;

import com.tydic.train.service.ly.task.bo.TrainLYTaskInstListRspBO;
import com.tydic.train.service.ly.task.bo.TrainLYTaskInstReqBO;
import com.tydic.train.service.ly.task.bo.TrainLYTaskInstRspBO;

import java.util.List;

/**
 * 描述：任务实例表
 *
 * @author: liaoyang
 * @date: 2023-08-30 16:09:28
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface TrainLYTaskInstRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO queryTrainTaskInstSingle(TrainLYTaskInstReqBO reqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstListRspBO queryTrainTaskInstList(TrainLYTaskInstReqBO reqBO);


    /**
     * 描述:新增信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO addTrainTaskInst(TrainLYTaskInstReqBO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstListRspBO addListTrainTaskInst(List<TrainLYTaskInstReqBO> reqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO updateTrainTaskInst(TrainLYTaskInstReqBO reqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO saveTrainTaskInst(TrainLYTaskInstReqBO reqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: TrainLYTaskInstReqBO
     * @return: TrainLYTaskInstRspBO
     * @author: liaoyang
     * @date: 2023-08-30 16:09:28
     */
    TrainLYTaskInstRspBO deleteTrainTaskInst(TrainLYTaskInstReqBO reqBO);

}

