package com.tydic.train.repository.zl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.train.service.zl.bo.TrainZLShipOrderItemBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderItemListRspBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderItemReqBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderItemRspBO;

import java.util.List;

/**
 * 描述：发货单明细表;发货单明细表
 *
 * @author: zhoulu
 * @date: 2023-08-31 11:07:52
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface TrainZLShipOrderItemRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: trainShipOrderItemReqBO
     * @return: TrainZLShipOrderItemRspBO
     * @author: zhoulu
     * @date: 2023-08-31 11:07:52
     */
    TrainZLShipOrderItemRspBO queryTrainZLShipOrderItemSingle(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: trainShipOrderItemReqBO
     * @return: TrainZLShipOrderItemRspBO
     * @author: zhoulu
     * @date: 2023-08-31 11:07:52
     */
    TrainZLShipOrderItemListRspBO queryTrainZLShipOrderItemList(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: trainShipOrderItemReqBO
     * @return: TrainZLShipOrderItemRspBO
     * @author: zhoulu
     * @date: 2023-08-31 11:07:52
     */
    TrainZLShipOrderItemRspBO addTrainZLShipOrderItem(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: trainShipOrderItemReqBO
     * @return: TrainZLShipOrderItemRspBO
     * @author: zhoulu
     * @date: 2023-08-31 11:07:52
     */
    TrainZLShipOrderItemListRspBO addListTrainZLShipOrderItem(List<TrainZLShipOrderItemReqBO> trainShipOrderItemReqBO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: trainShipOrderItemReqBO
     * @return: TrainZLShipOrderItemRspBO
     * @author: zhoulu
     * @date: 2023-08-31 11:07:52
     */
    TrainZLShipOrderItemRspBO updateTrainZLShipOrderItem(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: trainShipOrderItemReqBO
     * @return: TrainZLShipOrderItemRspBO
     * @author: zhoulu
     * @date: 2023-08-31 11:07:52
     */
    TrainZLShipOrderItemRspBO saveTrainZLShipOrderItem(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: trainShipOrderItemReqBO
     * @return: TrainZLShipOrderItemRspBO
     * @author: zhoulu
     * @date: 2023-08-31 11:07:52
     */
    TrainZLShipOrderItemRspBO deleteTrainZLShipOrderItem(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO);

}

