package com.tydic.train.repository.zl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.train.model.zl.TrainZLTaskInstDO;
import com.tydic.train.model.zl.TrainZLTaskInstListRspDO;
import com.tydic.train.model.zl.TrainZLTaskInstReqDO;
import com.tydic.train.model.zl.TrainZLTaskInstRspDO;

import java.util.List;

/**
 * 描述：任务实例表
 *
 * @author: zhoulu
 * @date: 2023-08-30 16:24:45
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface TrainZLTaskInstRepository {

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: trainTaskInstReqDO
     * @return: TrainZLTaskInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLTaskInstRspDO queryTrainZLTaskInstSingle(TrainZLTaskInstReqDO trainTaskInstReqDO);

    /**
     * 描述:查询信息列表
     *
     * @throws
     * @param: trainTaskInstReqDO
     * @return: TrainZLTaskInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLTaskInstListRspDO queryTrainZLTaskInstList(TrainZLTaskInstReqDO trainTaskInstReqDO);

    /**
     * 描述:新增信息
     *
     * @throws
     * @param: trainTaskInstReqDO
     * @return: TrainZLTaskInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLTaskInstRspDO addTrainZLTaskInst(TrainZLTaskInstReqDO trainTaskInstReqDO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: trainTaskInstReqDO
     * @return: TrainZLTaskInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLTaskInstListRspDO addListTrainZLTaskInst(List<TrainZLTaskInstReqDO> trainTaskInstReqDO);

    /**
     * 描述:修改信息
     *
     * @throws
     * @param: trainTaskInstReqDO
     * @return: TrainZLTaskInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLTaskInstRspDO updateTrainZLTaskInst(TrainZLTaskInstReqDO trainTaskInstReqDO);

    /**
     * 描述:保存信息
     *
     * @throws
     * @param: trainTaskInstReqDO
     * @return: TrainZLTaskInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLTaskInstRspDO saveTrainZLTaskInst(TrainZLTaskInstReqDO trainTaskInstReqDO);

    /**
     * 描述:删除信息
     *
     * @throws
     * @param: trainTaskInstReqDO
     * @return: TrainZLTaskInstRspDO
     * @author: zhoulu
     * @date: 2023-08-30 16:24:45
     */
    TrainZLTaskInstRspDO deleteTrainZLTaskInst(TrainZLTaskInstReqDO trainTaskInstReqDO);

}

