package com.tydic.train.service;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.train.model.xsd.order.TrainXsdOrderModel;
import com.tydic.train.model.xsd.order.sub.TrainXsdOrderDo;
import com.tydic.train.model.xsd.order.sub.TrainXsdOrderItemDo;
import com.tydic.train.service.course.TrainXsdCreateOrderService;
import com.tydic.train.service.course.bo.TrainXsdCreateOrderGoodsBo;
import com.tydic.train.service.course.bo.TrainXsdCreateOrderReqBO;
import com.tydic.train.service.course.bo.TrainXsdCreateOrderRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@HTServiceImpl
public class TrainXsdCreateOrderServiceImpl implements TrainXsdCreateOrderService {
    @Autowired
    private TrainXsdOrderModel trainXsdOrderModel;
    @Override
    public TrainXsdCreateOrderRspBO createOrder(TrainXsdCreateOrderReqBO reqBO) {
        TrainXsdCreateOrderRspBO rspBO = new TrainXsdCreateOrderRspBO();
        if (reqBO.getUserId()==null){
            throw new ZTBusinessException("用户信息为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getGoodsInfo())){
            throw new ZTBusinessException("商品信息为空");
        }else {
            for (TrainXsdCreateOrderGoodsBo trainXsdCreateOrderGoodsBo : reqBO.getGoodsInfo()) {
                if (trainXsdCreateOrderGoodsBo.getGoodsId()==null){
                    throw new ZTBusinessException("商品ID为空");
                }
                if (trainXsdCreateOrderGoodsBo.getCount()==null){
                    throw new ZTBusinessException("购买数量为空");
                }
                if (trainXsdCreateOrderGoodsBo.getGoodsPrice()==null){
                    throw new ZTBusinessException("商品价格为空");
                }
            }
        }

        //封装主体信息
        Long orderId = Sequence.getInstance().nextId();
        TrainXsdOrderDo trainXsdOrderDo = new TrainXsdOrderDo();
        trainXsdOrderDo.setOrderId(orderId);
        trainXsdOrderDo.setOrderNo("订单编号");
        trainXsdOrderDo.setOrderName("订单名称");
        trainXsdOrderDo.setCreateUserId(reqBO.getUserId());
        trainXsdOrderDo.setCreateUserName(reqBO.getUserName());
        trainXsdOrderDo.setCreateTime(new Date());
        trainXsdOrderDo.setDelFlag(0);

        //封装明细信息
        BigDecimal orderMoney = BigDecimal.ZERO;
        List<TrainXsdOrderItemDo> itemDos = new ArrayList<>();
        for (TrainXsdCreateOrderGoodsBo trainXsdCreateOrderGoodsBo : reqBO.getGoodsInfo()) {
            TrainXsdOrderItemDo trainXsdOrderItemDo = new TrainXsdOrderItemDo();
            trainXsdOrderItemDo.setGoodsId(trainXsdCreateOrderGoodsBo.getGoodsId());
            trainXsdOrderItemDo.setCount(trainXsdCreateOrderGoodsBo.getCount());
            trainXsdOrderItemDo.setGoodsPrice(trainXsdCreateOrderGoodsBo.getGoodsPrice());
            trainXsdOrderItemDo.setItemId(Sequence.getInstance().nextId());
            trainXsdOrderItemDo.setOrderId(trainXsdOrderDo.getOrderId());
            trainXsdOrderItemDo.setTotalMoney(trainXsdCreateOrderGoodsBo.getGoodsPrice().multiply(new BigDecimal(String.valueOf(trainXsdCreateOrderGoodsBo.getCount()))));
            trainXsdOrderItemDo.setDelFlag(0);
            orderMoney = orderMoney.add(trainXsdOrderItemDo.getTotalMoney());
            itemDos.add(trainXsdOrderItemDo);
        }
        trainXsdOrderDo.setOrderMoney(orderMoney);
        trainXsdOrderDo.setOrderItemInfo(itemDos);
        trainXsdOrderModel.createOrder(trainXsdOrderDo);
        rspBO.setOrderId(orderId);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
