package com.tydic.train.service;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.xsd.goods.TrainXsdGoodsModel;
import com.tydic.train.model.xsd.goods.sub.TrainXsdGoodsDo;
import com.tydic.train.service.course.TrainXsdQryGoodsService;
import com.tydic.train.service.course.bo.TrainXsdQryGoodsBo;
import com.tydic.train.service.course.bo.TrainXsdQryGoodsReqBO;
import com.tydic.train.service.course.bo.TrainXsdQryGoodsRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.course.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@HTServiceImpl
public class TrainXsdQryGoodsServiceImpl implements TrainXsdQryGoodsService {
    @Autowired
    private TrainXsdGoodsModel trainXsdGoodsModel;
    @Override
    public TrainXsdQryGoodsRspBO qryGoodsInfo(TrainXsdQryGoodsReqBO reqBO) {
        TrainXsdQryGoodsRspBO rspBO = new TrainXsdQryGoodsRspBO();
        if (CollectionUtils.isEmpty(reqBO.getGoodsIds())){
            throw new ZTBusinessException("请插入商品id");
        }
        List<TrainXsdQryGoodsBo> goodsInfo = new ArrayList<>();
        List<TrainXsdGoodsDo> trainXsdGoodsDos = trainXsdGoodsModel.qryGoodsList(reqBO.getGoodsIds());
        if (!CollectionUtils.isEmpty(trainXsdGoodsDos)){
            goodsInfo = JSONObject.parseArray(JSONObject.toJSONString(trainXsdGoodsDos),TrainXsdQryGoodsBo.class);
        }
        rspBO.setGoodsInfo(goodsInfo);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
