package com.tydic.train.service;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.lsq.approval.TrainLsqApprovalModel;
import com.tydic.train.model.lsq.approval.TrainLsqProcessInstDO;
import com.tydic.train.model.lsq.approval.sub.TrainLsqTaskInstDO;
import com.tydic.train.model.xsd.order.TrainXsdOrderModel;
import com.tydic.train.model.xsd.order.sub.TrainXsdOrderDo;
import com.tydic.train.service.course.TrainXsdQryOrderService;
import com.tydic.train.service.course.bo.TrainXsdQryOrderReqBO;
import com.tydic.train.service.course.bo.TrainXsdQryOrderRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

@HTServiceImpl
public class TrainXsdQryOrderServiceImpl implements TrainXsdQryOrderService {
    @Autowired
    private TrainXsdOrderModel trainXsdOrderModel;
    @Autowired
    private TrainLsqApprovalModel trainLsqApprovalModel;
    @Override
    public TrainXsdQryOrderRspBO qryOrderInfo(TrainXsdQryOrderReqBO reqBO) {
        TrainXsdQryOrderRspBO rspBO = new TrainXsdQryOrderRspBO();
        if (reqBO.getOrderId()==null){
            throw new ZTBusinessException("请传入订单id");
        }
        TrainXsdOrderDo trainXsdOrderDo = new TrainXsdOrderDo();
        trainXsdOrderDo.setOrderId(reqBO.getOrderId());
        TrainXsdOrderDo resutOrder= trainXsdOrderModel.getOrder(trainXsdOrderDo);
        if (resutOrder!=null){
            rspBO = JSONObject.parseObject(JSONObject.toJSONString(resutOrder),TrainXsdQryOrderRspBO.class);

            if (resutOrder.getOrderId()!=null) {
                //获取流程实例ID
                TrainLsqProcessInstDO trainLsqProcessInstDO = new TrainLsqProcessInstDO();
                trainLsqProcessInstDO.setObjId(resutOrder.getOrderId().toString());
                trainLsqProcessInstDO.setIsFinish(0);
                List<TrainLsqProcessInstDO> trainLsqProcessInstDO1 = trainLsqApprovalModel.qryProcessInstList(trainLsqProcessInstDO);
                if (!CollectionUtils.isEmpty(trainLsqProcessInstDO1)){
                    rspBO.setProcInstId(trainLsqProcessInstDO1.get(0).getProcInstId());

                    //获取taskId
                    TrainLsqTaskInstDO trainLsqTaskInstDO = new TrainLsqTaskInstDO();
                    trainLsqTaskInstDO.setStepStatus(0);
                    trainLsqTaskInstDO.setProcInstId(trainLsqProcessInstDO1.get(0).getProcInstId());
                    List<TrainLsqTaskInstDO> trainLsqTaskInstDOS = trainLsqApprovalModel.qryTaskInstList(trainLsqTaskInstDO);
                    if (!CollectionUtils.isEmpty(trainLsqTaskInstDOS)){
                        rspBO.setTaskId(trainLsqTaskInstDOS.get(0).getTaskId());
                    }
                }

            }
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
