package com.tydic.train.service.course;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.train.model.mc.good.TrainMcGoodDo;
import com.tydic.train.model.mc.good.TrainMcGoodModel;
import com.tydic.train.model.mc.good.qrybo.TrainMcGoodQryBo;
import com.tydic.train.model.mc.order.TrainMcOrderDo;
import com.tydic.train.model.mc.order.TrainMcOrderModel;
import com.tydic.train.model.mc.order.sub.TrainMcOrderItem;
import com.tydic.train.model.mc.user.TrainMcUserDo;
import com.tydic.train.model.mc.user.TrainMcUserModel;
import com.tydic.train.model.mc.user.qrybo.TrainMcUserQryBo;
import com.tydic.train.service.course.bo.TrainMcDealCreateOrderReqBo;
import com.tydic.train.service.course.bo.TrainMcDealCreateOrderRspBo;
import com.tydic.train.service.course.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题：TrainMcDealCreateOrderServiceImpl
 * 说明：
 * 时间：2023/08/28 19:16
 *
 * @author 马冲
 **/
@HTServiceImpl
public class TrainMcDealCreateOrderServiceImpl implements TrainMcDealCreateOrderService{

    @Autowired
    private TrainMcGoodModel trainMcGoodModel;
    @Autowired
    private TrainMcUserModel trainMcUserModel;
    @Autowired
    private TrainMcOrderModel trainMcOrderModel;

    @Override
    public TrainMcDealCreateOrderRspBo dealCreateOrder(TrainMcDealCreateOrderReqBo reqBo) {
        TrainMcDealCreateOrderRspBo rspBo = new TrainMcDealCreateOrderRspBo();
        //校验商品，用户存在
        TrainMcGoodQryBo goodQryBo = new TrainMcGoodQryBo();
        goodQryBo.setGoodsId(reqBo.getGoodsId());
        TrainMcGoodDo goodDo = trainMcGoodModel.qryGoods(goodQryBo);
        if(ObjectUtil.isEmpty(goodDo)){
            rspBo.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBo.setRespDesc("订单创建失败，商品不存在");
            return rspBo;
        }
        TrainMcUserQryBo userQryBo = new TrainMcUserQryBo();
        userQryBo.setUserId(reqBo.getUserId());
        TrainMcUserDo userDo = trainMcUserModel.qryUser(userQryBo);
        if(ObjectUtil.isEmpty(userDo)){
            rspBo.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBo.setRespDesc("订单创建失败，用户不存在");
            return rspBo;
        }

        TrainMcOrderDo createOrderDo = new TrainMcOrderDo();
        Date now = new Date();
        createOrderDo.setOrderNo("mc" + now);
        createOrderDo.setOrderName("mc" + now);
        createOrderDo.setOrderMoney(new BigDecimal(reqBo.getBuyCount()).multiply(goodDo.getGoodsPrice()));
        createOrderDo.setCreateTime(now);
        createOrderDo.setCreateUserName(userDo.getUserName());
        createOrderDo.setCreateUserId(reqBo.getUserId());

        List<TrainMcOrderItem> orderItemBoList = new ArrayList<>();
        TrainMcOrderItem orderItem = new TrainMcOrderItem();
        orderItem.setCount(reqBo.getBuyCount());
        orderItem.setGoodsPrice(goodDo.getGoodsPrice());
        orderItem.setGoodsId(goodQryBo.getGoodsId());
        orderItem.setTotalMoney(new BigDecimal(reqBo.getBuyCount()).multiply(goodDo.getGoodsPrice()));
        orderItemBoList.add(orderItem);
        createOrderDo.setOrderItemBoList(orderItemBoList);
        TrainMcOrderDo orderDo = trainMcOrderModel.createOrder(createOrderDo);

        rspBo.setOrderId(orderDo.getOrderId());
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }
}
