package com.tydic.train.service.course;

import com.tydic.train.model.mc.task.TrainMcTaskDo;
import com.tydic.train.model.mc.task.TrainMcTaskModel;
import com.tydic.train.service.course.bo.TrainMcDealTaskReqBO;
import com.tydic.train.service.course.bo.TrainMcDealTaskRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：TrainMcDealTaskServiceImpl
 * 说明：
 * 时间：2023/08/30 16:55
 *
 * @author 马冲
 **/
@HTServiceImpl
public class TrainMcDealTaskServiceImpl implements TrainMcDealTaskService{

    @Autowired
    private TrainMcTaskModel trainMcTaskModel;

    @Override
    public TrainMcDealTaskRspBO dealTask(TrainMcDealTaskReqBO reqBO) {

        TrainMcTaskDo taskDo = JsonUtil.js(reqBO,TrainMcTaskDo.class);
        trainMcTaskModel.dealTask(taskDo);

        TrainMcDealTaskRspBO rspBO = new TrainMcDealTaskRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
